/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.server.handler.ImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatQueueApi;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;

@CommandHandler(value=Command.HeartbeatReq)
public class HeartbeatReqHandler
implements ImServerHandler {
    private static Logger log = LoggerFactory.getLogger(HeartbeatReqHandler.class);
    public static final HeartbeatReqHandler me = new HeartbeatReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket) throws Exception {
        User curr = ImUtils.getUser((ChannelContext)channelContext);
        if (curr != null) {
            Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
            try {
                if (Objects.equals(devicetype.getValue(), Devicetype.IOS.getValue()) || Objects.equals(devicetype.getValue(), Devicetype.ANDROID.getValue())) {
                    devicetype = Devicetype.APP;
                }
                if (Objects.equals(devicetype.getValue(), Devicetype.APP.getValue())) {
                    String key = curr.getId() + "_" + devicetype;
                    if (Const.IM_HEARTBEAT_TIMEOUT <= 20000L) {
                        Long refreshtime = (Long)Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).get(key);
                        if (refreshtime == null || refreshtime <= 0L) {
                            refreshtime = DateUtil.offsetMillisecond((Date)new DateTime(), (int)Const.FOCUS_REFRESH_TIMEOUT).getTime();
                            Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).put(key, (Serializable)refreshtime);
                            return;
                        }
                        if (refreshtime <= new DateTime().getTime()) {
                            Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).remove(key);
                            WxChatQueueApi.refreshFocusQueue(curr, devicetype.getValue(), channelContext.getId());
                        }
                    } else {
                        WxChatQueueApi.refreshFocusQueue(curr, devicetype.getValue(), channelContext.getId());
                    }
                } else {
                    String key = curr.getId() + "_" + devicetype + "_" + channelContext.getId();
                    Long refreshtime = (Long)Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).get(key);
                    if (refreshtime == null || refreshtime <= 0L) {
                        refreshtime = DateUtil.offsetMillisecond((Date)new DateTime(), (int)Const.FOCUS_REFRESH_TIMEOUT).getTime();
                        Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).put(key, (Serializable)refreshtime);
                        return;
                    }
                    if (refreshtime <= new DateTime().getTime()) {
                        Caches.getCache((CacheConfig)CacheConfig.CHAT_FOCUS_REFRESH_TIME_1).remove(key);
                        WxChatQueueApi.refreshFocusQueue(curr, devicetype.getValue(), channelContext.getId());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

