/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.sys.WxSynRecordNtf;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.main.WxFriendApplyItems;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.sitexxx.service.vo.wx.SynRecordVo;
import org.tio.utils.json.Json;

public class WxSynApi {
    private static Logger log = LoggerFactory.getLogger(WxSynApi.class);
    public static final WxSynApi me = new WxSynApi();

    public static void synMsgFocusJoin(Long chatlinkid, String uid, FocusVo focusVo) {
        HashMap<String, Object> bizdata = new HashMap<String, Object>();
        bizdata.put("chatlinkid", chatlinkid);
        bizdata.put("uid", uid);
        bizdata.put("readflag", (byte)1);
        bizdata.put("readtime", new Date());
        bizdata.put("readdevice", focusVo.getDevicetype());
        bizdata.put("readipid", focusVo.getIpid());
        WxSynApi.synNtf(uid, (Byte)2, (Byte)3, bizdata);
    }

    public static void synChatSession(String uid, WxChatItems chatItems, Byte synType) {
        if (chatItems.getChatlinkid() == null) {
            chatItems.setChatlinkid(chatItems.getId());
        }
        WxSynApi.synNtf((Object)chatItems, uid, (Byte)1, synType);
    }

    public static void synMsgClear(String uid, Long chatlinkid) {
        HashMap<String, Object> bizdata = new HashMap<String, Object>();
        bizdata.put("chatlinkid", chatlinkid);
        WxSynApi.synNtf(uid, (Byte)2, (Byte)5, bizdata);
    }

    public static void synP2pMsgBak(String uid, Long chatlinkid, Long mid) {
        HashMap<String, Object> bizdata = new HashMap<String, Object>();
        bizdata.put("chatlinkid", chatlinkid);
        bizdata.put("id", mid);
        WxSynApi.synNtf(uid, (Byte)2, (Byte)4, bizdata);
    }

    public static void synGroupMsgBak(Long groupid, Long mid) {
        HashMap<String, Object> bizdata = new HashMap<String, Object>();
        bizdata.put("chatlinkid", -groupid.longValue());
        bizdata.put("id", mid);
        WxSynApi.synNtf(groupid, (Byte)2, (Byte)4, bizdata);
    }

    public static void synP2pMsgDel(String uid, Long chatlinkid, String mids, WxChatItems chatItems) {
        ArrayList<SynRecordVo> synRecordVos = new ArrayList<SynRecordVo>();
        for (String mid : mids.split(",")) {
            HashMap<String, Long> bizdata = new HashMap<String, Long>();
            bizdata.put("chatlinkid", chatlinkid);
            bizdata.put("id", Long.parseLong(mid));
            synRecordVos.add(new SynRecordVo(Byte.valueOf((byte)2), Byte.valueOf((byte)4), bizdata));
        }
        if (chatItems != null) {
            if (chatItems.getChatlinkid() == null) {
                chatItems.setChatlinkid(chatItems.getId());
            }
            WxSynApi.synInit((Byte)1, (Byte)2, chatItems, synRecordVos);
        }
        WxSynApi.synManyNtf(uid, synRecordVos);
    }

    public static void synGroupMsgDel(String uid, Long groupid, String mids, WxChatItems chatItems) {
        ArrayList<SynRecordVo> synRecordVos = new ArrayList<SynRecordVo>();
        for (String mid : mids.split(",")) {
            HashMap<String, Long> bizdata = new HashMap<String, Long>();
            bizdata.put("chatlinkid", -groupid.longValue());
            bizdata.put("id", Long.parseLong(mid));
            synRecordVos.add(new SynRecordVo(Byte.valueOf((byte)2), Byte.valueOf((byte)4), bizdata));
        }
        if (chatItems != null) {
            if (chatItems.getChatlinkid() == null) {
                chatItems.setChatlinkid(Long.valueOf(-groupid.longValue()));
            }
            chatItems.setId(Long.valueOf(-groupid.longValue()));
            WxSynApi.synInit((Byte)1, (Byte)2, chatItems, synRecordVos);
        }
        WxSynApi.synManyNtf(uid, synRecordVos);
    }

    public static void synFriendDel(String uid, String touid, Long chatlinkid, Long tochatlinkid, Long fid) {
        ArrayList<SynRecordVo> uidSynVos = new ArrayList<SynRecordVo>();
        if (chatlinkid != null) {
            HashMap<String, Object> uidMap = new HashMap<String, Object>();
            uidMap.put("chatlinkid", chatlinkid);
            WxSynApi.synInit((Byte)1, (Byte)4, uidSynVos, uidMap);
        }
        HashMap<String, Object> fidMap = new HashMap<String, Object>();
        fidMap.put("id", fid);
        WxSynApi.synInit((Byte)3, (Byte)4, uidSynVos, fidMap);
        WxSynApi.synManyNtf(uid, uidSynVos);
        if (tochatlinkid != null) {
            HashMap<String, Object> bizdata = new HashMap<String, Object>();
            bizdata.put("chatlinkid", tochatlinkid);
            bizdata.put("linkflag", (byte)2);
            WxSynApi.synNtf(touid, (Byte)1, (Byte)2, bizdata);
        }
    }

    public static void synFriend(String uid, WxFriend friend, Byte synType) {
        WxSynApi.synNtf((Object)friend, uid, (Byte)3, synType);
    }

    public static void synFriendApply(String uid, WxFriendApplyItems apply, Byte synType) {
        WxSynApi.synNtf((Object)apply, uid, (Byte)4, synType);
    }

    public static void synFdRemarkName(String uid, Long fid, String remarkName, Long chatlinkid) {
        ArrayList<SynRecordVo> uidSynVos = new ArrayList<SynRecordVo>();
        if (chatlinkid != null) {
            HashMap<String, Object> uidMap = new HashMap<String, Object>();
            uidMap.put("chatlinkid", chatlinkid);
            uidMap.put("name", remarkName);
            WxSynApi.synInit((Byte)1, (Byte)2, uidSynVos, uidMap);
        }
        HashMap<String, Object> fidMap = new HashMap<String, Object>();
        fidMap.put("id", fid);
        fidMap.put("remarkname", remarkName);
        WxSynApi.synInit((Byte)3, (Byte)2, uidSynVos, fidMap);
        WxSynApi.synManyNtf(uid, uidSynVos);
    }

    public static void synNtf(Object object, String uid, Byte biztype, Byte syntype) {
        if (uid == null || biztype == null || syntype == null || object == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,uid:{},biztype:{},syntype:{},bizdata:{}", new Object[]{uid, biztype, syntype, object});
            return;
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(new SynRecordVo(object, biztype, syntype));
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToUser(uid, imPacket);
    }

    public static void synNtf(Object object, Long groupid, Byte biztype, Byte syntype) {
        if (groupid == null || biztype == null || syntype == null || object == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff08\u7fa4\uff09\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,uid:{},biztype:{},syntype:{},bizdata:{}", new Object[]{groupid, biztype, syntype, object});
            return;
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(new SynRecordVo(object, biztype, syntype));
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToGroup(groupid, imPacket);
    }

    public static void synNtf(String uid, Byte biztype, Byte syntype, Map<String, Object> bizdata) {
        if (uid == null || biztype == null || syntype == null || bizdata == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,uid:{},biztype:{},syntype:{},bizdata:{}", new Object[]{uid, biztype, syntype, bizdata});
            return;
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(new SynRecordVo(biztype, syntype, bizdata));
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToUser(uid, imPacket);
    }

    public static void synNtf(Long groupid, Byte biztype, Byte syntype, Map<String, Object> bizdata) {
        if (groupid == null || biztype == null || syntype == null || bizdata == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,groupid:{},biztype:{},syntype:{},bizdata:{}", new Object[]{groupid, biztype, syntype, bizdata});
            return;
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(new SynRecordVo(biztype, syntype, bizdata));
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToGroup(groupid, imPacket);
    }

    public static void synEqualNtf(String uid, Byte biztype, Byte syntype, List<Map<String, Object>> bizdatas) {
        if (uid == null || biztype == null || syntype == null || bizdatas == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,uid:{},biztype:{},syntype:{},bizdatas:{}", new Object[]{uid, biztype, syntype, bizdatas});
            return;
        }
        ArrayList<SynRecordVo> synRecordVos = new ArrayList<SynRecordVo>();
        for (Map<String, Object> object : bizdatas) {
            synRecordVos.add(new SynRecordVo(biztype, syntype, object));
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(synRecordVos);
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToUser(uid, imPacket);
    }

    public static void synEqualNtf(Long groupid, Byte biztype, Byte syntype, List<Map<String, Object>> bizdatas) {
        if (groupid == null || biztype == null || syntype == null || bizdatas == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,groupid:{},biztype:{},syntype:{},bizdatas:{}", new Object[]{groupid, biztype, syntype, bizdatas});
            return;
        }
        ArrayList<SynRecordVo> synRecordVos = new ArrayList<SynRecordVo>();
        for (Map<String, Object> object : bizdatas) {
            synRecordVos.add(new SynRecordVo(biztype, syntype, object));
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(synRecordVos);
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToGroup(groupid, imPacket);
    }

    public static void synManyNtf(String uid, List<SynRecordVo> synRecordVos) {
        if (uid == null || synRecordVos == null) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u89e6\u53d1\u5f02\u5e38\uff1a\u53c2\u6570\u5b58\u5728\u7a7a\u503c,uid:{},synRecordVos:{}", (Object)uid, synRecordVos);
            return;
        }
        WxSynRecordNtf ntf = new WxSynRecordNtf(synRecordVos);
        ImPacket imPacket = new ImPacket(Command.WxSynRecordNtf, Json.toJson((Object)ntf));
        Ims.sendToUser(uid, imPacket);
    }

    public static void synInit(Byte biztype, Byte syntype, Object object, List<SynRecordVo> synRecordVos) {
        if (synRecordVos == null) {
            return;
        }
        synRecordVos.add(new SynRecordVo(object, biztype, syntype));
    }

    public static void synInit(Byte biztype, Byte syntype, List<SynRecordVo> synRecordVos, Map<String, Object> bizdata) {
        if (synRecordVos == null) {
            return;
        }
        synRecordVos.add(new SynRecordVo(biztype, syntype, bizdata));
    }

    public static boolean isSynVersion() {
        return WxSynApi.isSynVersion(null);
    }

    public static boolean isSynVersion(Byte deviceType) {
        return Const.SYN_NEW_VERSION;
    }
}

