/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx;

import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.HandshakeReq;
import org.tio.sitexxx.im.common.bs.wx.WxUpdateTokenReq;
import org.tio.sitexxx.im.common.bs.wx.WxUpdateTokenResp;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxUpdateTokenReq)
public class WxUpdateTokenReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxUpdateTokenReqHandler.class);

    @Override
    public boolean needLogin() {
        return false;
    }

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        ImSessionContext imSessionContext = org.tio.sitexxx.im.common.utils.ImUtils.getImSessionContext((ChannelContext)channelContext);
        WxUpdateTokenReq updateTokenReq = (WxUpdateTokenReq)Json.toBean((String)packet.getBodyStr(), WxUpdateTokenReq.class);
        String newToken = updateTokenReq.getT();
        HandshakeReq handshakeReq = org.tio.sitexxx.im.common.utils.ImUtils.getHandshakeReq((ChannelContext)channelContext);
        String oldToken = handshakeReq.getToken();
        handshakeReq.setToken(newToken);
        User user = null;
        if (!Objects.equals(newToken, oldToken)) {
            Tio.unbindToken((ChannelContext)channelContext);
            Tio.unbindUser((ChannelContext)channelContext);
        }
        if (StrUtil.isNotBlank((CharSequence)newToken)) {
            Tio.unbindGroup((ChannelContext)channelContext);
            Tio.bindToken((ChannelContext)channelContext, (String)newToken);
            String userid = null;
            user = org.tio.sitexxx.im.common.utils.ImUtils.getUser((String)newToken);
            if (user == null) {
                ImUtils.pleaseLogin(channelContext, "\u91cd\u65b0\u7ed1\u5b9a\u672a\u767b\u5f55token\uff0c\u8bf7\u65ad\u5f00\u8fde\u63a5");
                Tio.close((ChannelContext)channelContext, (String)"\u91cd\u65b0\u7ed1\u5b9a\u672a\u767b\u5f55token\uff0c\u8bf7\u65ad\u5f00\u8fde\u63a5");
                return;
            }
            userid = user.getId();
            if (userid != null) {
                Tio.bindUser((ChannelContext)channelContext, (String)(userid + ""));
                imSessionContext.setUid(userid);
                List userItems = ChatIndexService.me.getLinkActUserIndex(userid, Byte.valueOf((byte)2), Byte.valueOf((byte)1), Byte.valueOf((byte)1));
                if (CollUtil.isNotEmpty((Collection)userItems)) {
                    for (WxChatUserItem index : userItems) {
                        Tio.bindGroup((ChannelContext)channelContext, (String)(index.getBizid() + ""));
                    }
                }
            }
        }
        org.tio.sitexxx.im.common.utils.ImUtils.rebindGroups((ChannelContext)channelContext);
        WxUpdateTokenResp updateTokenResp = new WxUpdateTokenResp();
        ImPacket imPacket = new ImPacket(Command.WxUpdateTokenResp, (Object)updateTokenResp);
        Ims.send(channelContext, imPacket);
    }
}

