/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.call;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall14EndNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.base.WxCallBase;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.main.WxCallLog;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.wx.WxCallItemVo;
import org.tio.utils.cache.ICache;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.ReadWriteLockHandler;

public class WxCallUtils {
    private static Logger log = LoggerFactory.getLogger(WxCallUtils.class);
    public static final String LOCK_KEY_PREFIX = "wx_call_";

    public static void endAllCall() {
        String sql = "update wx_call_item set status = ?, hanguptype = ? where status != ?";
        Db.use((String)"tio_site_main").update(sql, new Object[]{(byte)4, (byte)7, (byte)4});
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING);
        cache.clear();
        Caches.getCache((CacheConfig)CacheConfig.WxCallItem).clear();
    }

    public static void clearCallId(String channelContextId) {
        ImSessionContext imSessionContext;
        ChannelContext channelContext;
        if (channelContextId != null && (channelContext = Tio.getByChannelContextId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)channelContextId)) != null && (imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext)) != null) {
            imSessionContext.setCallId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WxCallItem endCall(final ChannelContext channelContext, Long callId, final String hangupuid, final Byte hanguptype) {
        final WxCallItem wxCallItem = WxCallItemService.me.getById(callId);
        if (wxCallItem == null) {
            return null;
        }
        try {
            LockUtils.runWriteOrWaitRead((String)("wx_call_end" + callId), WxCallUtils.class, (ReadWriteLockHandler)new ReadWriteLockHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write() throws Exception {
                    block16: {
                        try {
                            if (Objects.equals(wxCallItem.getStatus(), (byte)4)) {
                                return;
                            }
                            wxCallItem.setHangupuid(hangupuid);
                            wxCallItem.setHanguptype(hanguptype);
                            Date date = new Date();
                            wxCallItem.setStatus(Byte.valueOf((byte)4));
                            wxCallItem.setEndtime(date);
                            if (wxCallItem.getConnectedtime() != null) {
                                wxCallItem.setCallduration(Long.valueOf(date.getTime() - wxCallItem.getConnectedtime().getTime()));
                            }
                            wxCallItem.update();
                            WxCallUtils.clearCallId(wxCallItem.getFromcid());
                            WxCallUtils.clearCallId(wxCallItem.getTocid());
                            if (!Objects.equals(hanguptype, (byte)10)) {
                                WxCall14EndNtf ntf = new WxCall14EndNtf();
                                ntf.fill(wxCallItem);
                                ImPacket toPacket = new ImPacket(Command.WxCall14EndNtf, (Object)ntf);
                                Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)ntf.getFromcid(), (Packet)toPacket);
                                if (!Objects.equals(hanguptype, (byte)3)) {
                                    if (StrUtil.isNotBlank((CharSequence)ntf.getTocid())) {
                                        Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)ntf.getTocid(), (Packet)toPacket);
                                    } else {
                                        Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)(ntf.getTouid() + ""), (Packet)toPacket);
                                    }
                                }
                            }
                            try {
                                WxCallItemVo callItemVo = new WxCallItemVo();
                                Byte contenttype = 10;
                                if (Objects.equals(wxCallItem.getType(), (byte)1)) {
                                    contenttype = 11;
                                }
                                callItemVo.setCalltype(contenttype);
                                callItemVo.setDuration(wxCallItem.getCallduration());
                                callItemVo.setHanguptype(hanguptype);
                                callItemVo.setHangupuid(hangupuid);
                                callItemVo.setDevicetype(wxCallItem.getTodevice());
                                WxChatUserItem userItem = ChatIndexService.fdUserIndex((String)wxCallItem.getFromuid(), (String)wxCallItem.getTouid());
                                if (!ChatService.friendExistChat((WxChatUserItem)userItem)) {
                                    log.error("\u97f3\u89c6\u9891\u901a\u8bdd\u5f02\u5e38,\u4f1a\u8bdd\u672a\u6fc0\u6d3b\uff1auid:{},touid:{},callid:{}", new Object[]{wxCallItem.getFromuid(), wxCallItem.getTouid(), wxCallItem.getId()});
                                    break block16;
                                }
                                WxChatApi.sendFdMsgEach(channelContext, Json.toJson((Object)callItemVo), contenttype, wxCallItem.getFromuid(), wxCallItem.getTouid(), userItem.getChatlinkid(), (Byte)2);
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                        finally {
                            ICache cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING);
                            cache.remove(wxCallItem.getFromuid() + "");
                            cache.remove(wxCallItem.getTouid() + "");
                            cache.remove(wxCallItem.getFromuid() + "_" + wxCallItem.getFromdevice());
                            cache.remove(wxCallItem.getTouid() + "_" + wxCallItem.getTodevice());
                            WxCallItemService.me.clearWxCallItem(wxCallItem.getId());
                        }
                    }
                }
            }, (Long)10L);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return wxCallItem;
    }

    public static WxCallLog callLog(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, WxCallBase req) throws Exception {
        WxCallLog wxCallLog = WxCallLog.from((WxCallItem)req);
        wxCallLog.setData(packet.getBodyStr());
        wxCallLog.setUid(curr.getId());
        return wxCallLog;
    }

    public static boolean saveCallLog(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, WxCallBase req, String summary) {
        try {
            WxCallLog wxCallLog = WxCallUtils.callLog(packet, channelContext, isWebsocket, curr, req);
            wxCallLog.setSummary(summary);
            return wxCallLog.save();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateItem(WxCallItem wxCallItem) {
        Serializable lockobj;
        Long callId = wxCallItem.getId();
        Serializable serializable = lockobj = LockUtils.getLockObj((String)("wx_call_update" + callId), WxCallUtils.class);
        synchronized (serializable) {
            wxCallItem.update();
        }
        WxCallItemService.me.clearWxCallItem(wxCallItem.getId());
    }
}

