/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.chatitem;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.chatitem.WxChatItemInfoReq;
import org.tio.sitexxx.im.common.bs.wx.chatitem.WxChatItemInfoResp;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxChatItemInfoReq)
public class WxChatItemInfoReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxChatItemInfoReqHandler.class);
    public static final WxChatItemInfoReqHandler me = new WxChatItemInfoReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxChatItems chatItems;
        WxChatItemInfoReq infoReq = (WxChatItemInfoReq)Json.toBean((String)packet.getBodyStr(), WxChatItemInfoReq.class);
        Long chatlinkid = infoReq.getChatlinkid();
        if (chatlinkid == null) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20001, "\u4f1a\u8bdd\u4e3a\u7a7a");
            return;
        }
        Long oldchatlinkid = chatlinkid;
        if (chatlinkid <= 0L) {
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)(-chatlinkid.longValue()));
            if (groupItem == null || groupItem.getChatlinkid() == null) {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), oldchatlinkid, (Integer)30001, "\u4f1a\u8bdd\u4e3a\u7a7a");
                return;
            }
            chatlinkid = groupItem.getChatlinkid();
        }
        if ((chatItems = ChatService.me.getChatItems(chatlinkid)) == null) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), oldchatlinkid, (Integer)20001, "\u4f1a\u8bdd\u4e0d\u5b58\u5728");
            return;
        }
        if (!Objects.equals(curr.getId(), chatItems.getUid())) {
            log.error("\u5f02\u5e38\u767b\u5f55\u8bf7\u6c42\u4f1a\u8bdd\u4fe1\u606f\uff1a\u767b\u5f55uid\uff1a{}\uff0c\u8bf7\u6c42\u4f1a\u8bdd\u7684uid\uff1a{}", (Object)curr.getId(), (Object)chatItems.getUid());
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), oldchatlinkid, (Integer)1008, "\u5f02\u5e38\u767b\u5f55\u8bf7\u6c42");
            return;
        }
        WxChatItemInfoResp infoResp = new WxChatItemInfoResp();
        infoResp.setData(chatItems);
        infoResp.setChatlinkid(oldchatlinkid);
        ImPacket imPacket = new ImPacket(Command.WxChatItemInfoResp, (Object)infoResp);
        Ims.send(channelContext, imPacket);
    }
}

