/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.friend;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.jfinal.kit.Ret;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.WxNotFriendNtf;
import org.tio.sitexxx.im.common.bs.wx.friend.WxFriendChatNtf;
import org.tio.sitexxx.im.common.bs.wx.friend.WxFriendChatReq;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.WxChatQueueApi;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxFriendMsg;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserRoleService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.chat.SynService;
import org.tio.sitexxx.service.service.wx.WxFriendService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.sitexxx.service.vo.wx.WxMsgCardVo;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxFriendChatReq)
public class WxFriendChatReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxFriendChatReqHandler.class);
    public static final WxFriendChatReqHandler me = new WxFriendChatReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxFriendChatReq wxFriendChatReq = (WxFriendChatReq)Json.toBean((String)packet.getBodyStr(), WxFriendChatReq.class);
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        String c = wxFriendChatReq.getC();
        if (wxFriendChatReq.getCardid() == null && StrUtil.isBlank((CharSequence)c)) {
            return;
        }
        String text = c;
        Long chatlinkid = wxFriendChatReq.getChatlinkid();
        if (Objects.equals(curr.getMsgforbiddenflag(), (byte)1)) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20005, "\u4f60\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u8a00");
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)c) && c.length() > 2048) {
            ImUtils.info(channelContext, "\u4f60\u53d1\u7684\u5185\u5bb9\u6709\u70b9\u957f^_^", null);
            return;
        }
        if (chatlinkid != null) {
            Ret ret;
            WxChatItems chatItems = ChatService.me.getChatItems(chatlinkid);
            Ret check = WxChatApi.checkFriendChat(curr.getId(), chatItems);
            if (check.isFail()) {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, RetUtils.getIntCode((Ret)check), RetUtils.getRetMsg((Ret)check));
                return;
            }
            String touid = chatItems.getBizid();
            User toUser = UserService.ME.getById(touid);
            if (toUser == null) {
                Tio.remove((ChannelContext)channelContext, (String)("\u63d0\u4f9b\u4e86\u9519\u8bef\u7684userid[" + touid + "]"));
                return;
            }
            if (!UserRoleService.checkUserStatus((User)toUser)) {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20004, "\u65e0\u6548\u7528\u6237");
                return;
            }
            Byte contenttype = 1;
            if (wxFriendChatReq.getCardid() != null) {
                ret = null;
                if (Objects.equals(wxFriendChatReq.getCardtype(), (byte)1)) {
                    ret = FriendService.me.getFdCard(curr.getId(), wxFriendChatReq.getCardid());
                } else if (Objects.equals(wxFriendChatReq.getCardtype(), (byte)2)) {
                    ret = GroupService.me.getGroupCard(curr.getId(), Long.valueOf(Long.parseLong(wxFriendChatReq.getCardid())));
                } else {
                    WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20001, "\u65e0\u6548\u540d\u7247\u7c7b\u578b");
                    return;
                }
                if (ret.isFail()) {
                    WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20001, RetUtils.getRetMsg((Ret)ret));
                    return;
                }
                WxMsgCardVo cardVo = (WxMsgCardVo)RetUtils.getOkTData((Ret)ret);
                cardVo.setShareToBizid(touid);
                text = Json.toJson((Object)cardVo);
                contenttype = 9;
            }
            if ((ret = WxChatApi.sendFdMsgEach(channelContext, text, contenttype, curr.getId(), toUser.getId(), chatlinkid, (Byte)2)).isFail()) {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, RetUtils.getIntCode((Ret)ret), RetUtils.getRetMsg((Ret)ret));
                return;
            }
            Map focusMap = SynService.me.focusDevice(curr.getId(), devicetype.getValue());
            if (focusMap == null || focusMap.get(chatlinkid + "") == null) {
                IpInfo ipInfo = IpInfoService.ME.save(channelContext.getClientNode().getIp());
                WxChatQueueApi.joinFocusQueue(channelContext, curr, chatlinkid, null, (byte)1, devicetype.getValue(), ipInfo.getId());
            }
        } else {
            log.error("\u79c1\u804a\u4f1a\u8bddid\u4e3a\u7a7a");
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), null, (Integer)20001, "\u4f1a\u8bdd\u4e3a\u7a7a");
            return;
        }
    }

    public static boolean p2pChatAndLog(ChannelContext channelContext, String text, String fromUid, String toUid, Byte contenttype, byte readflag) throws Exception {
        return WxFriendChatReqHandler.p2pChatAndLog(channelContext, text, fromUid, toUid, contenttype, readflag, (byte)2);
    }

    public static boolean p2pChatAndLog(ChannelContext channelContext, String text, String fromUid, String toUid, Byte contenttype, byte readflag, Byte sendbysys) throws Exception {
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        String sessionid = ImUtils.getToken((ChannelContext)channelContext);
        String fromIp = channelContext.getClientNode().getIp();
        return WxFriendChatReqHandler.p2pChatAndLog(devicetype, sessionid, fromIp, text, fromUid, toUid, contenttype, readflag, sendbysys);
    }

    public static boolean p2pChatAndLog(Devicetype devicetype, String sessionid, String fromIp, String text, String fromUid, String toUid, Byte contenttype, byte readflag) throws Exception {
        return WxFriendChatReqHandler.p2pChatAndLog(devicetype, sessionid, fromIp, text, fromUid, toUid, contenttype, readflag, (byte)2);
    }

    public static boolean p2pChatAndLog(Devicetype devicetype, String sessionid, String fromIp, String text, String fromUid, String toUid, Byte contenttype, byte readflag, Byte sendbysys) throws Exception {
        User fromUser = UserService.ME.getById(fromUid);
        if (fromUser == null) {
            return false;
        }
        User toUser = UserService.ME.getById(toUid);
        if (toUser == null) {
            return false;
        }
        boolean isFriend = WxFriendService.me.isFriend(fromUid, toUid);
        if (!isFriend && !Objects.equals(fromUid, toUid)) {
            WxNotFriendNtf wxNotFriendNtf = new WxNotFriendNtf();
            wxNotFriendNtf.setUid(toUid);
            boolean inMyFriendList = WxFriendService.me.inMyFriendList(fromUid, toUid);
            if (inMyFriendList) {
                wxNotFriendNtf.setType((byte)1);
            } else {
                boolean inOtherFriendList = WxFriendService.me.inMyFriendList(toUid, fromUid);
                if (inOtherFriendList) {
                    wxNotFriendNtf.setType((byte)2);
                } else {
                    wxNotFriendNtf.setType((byte)3);
                }
            }
            ImPacket imPacket = new ImPacket(Command.WxNotFriendNtf, (Object)wxNotFriendNtf);
            Ims.sendToUser(fromUid, imPacket);
            return false;
        }
        WxFriendMsg wxFriendMsg = WxFriendService.me.saveChatRecord(devicetype, sessionid, text, fromUid, fromIp, toUid, contenttype, readflag, sendbysys);
        WxFriendChatNtf p2PChatNtf = WxFriendChatNtf.from((WxFriendMsg)wxFriendMsg);
        ImPacket imPacket = null;
        if (7 == contenttype) {
            imPacket = new ImPacket(Command.RunJsNtf, Json.toJson((Object)p2PChatNtf));
            Ims.sendToUser(toUid, imPacket);
        } else {
            imPacket = new ImPacket(Command.WxFriendChatNtf, (Object)p2PChatNtf);
            Ims.sendToUser(toUid, imPacket);
            if (!Objects.equals(toUid, fromUid)) {
                Ims.sendToUser(fromUid, imPacket);
            }
        }
        return true;
    }
}

