/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.group;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.jfinal.kit.Ret;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.group.WxGroupMsgReq;
import org.tio.sitexxx.im.common.bs.wx.group.WxGroupMsgResp;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatMsgService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxGroupMsgReq)
public class WxGroupMsgReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxGroupMsgReqHandler.class);
    public static final WxGroupMsgReqHandler me = new WxGroupMsgReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxGroupMsgReq msgReq = (WxGroupMsgReq)Json.toBean((String)packet.getBodyStr(), WxGroupMsgReq.class);
        Long chatlinkid = msgReq.getChatlinkid();
        Long startmid = msgReq.getStartmid();
        Long endmid = msgReq.getEndmid();
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)Math.abs(chatlinkid));
        if (groupItem == null || groupItem.getChatlinkid() == null) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)30001, "\u4f1a\u8bdd\u4e3a\u7a7a");
            return;
        }
        chatlinkid = groupItem.getChatlinkid();
        Ret ret = ChatMsgService.me.groupMsgList(chatlinkid, curr.getId(), startmid, endmid);
        if (ret.isFail()) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupItem.getGroupid().longValue()), (Integer)30001, RetUtils.getRetMsg((Ret)ret));
            return;
        }
        List list = (List)RetUtils.getOkTData((Ret)ret);
        WxGroupMsgResp msgResp = new WxGroupMsgResp();
        msgResp.setData(list);
        if (list.size() < ConfService.getInt((String)"im.history.chat.count.group", (Integer)GroupService.GROUP_MSG_LIMIT)) {
            msgResp.setLastPage(true);
        }
        msgResp.setChatlinkid(Long.valueOf(-groupItem.getGroupid().longValue()));
        ImPacket imPacket = new ImPacket(Command.WxGroupMsgResp, (Object)msgResp);
        Ims.send(channelContext, imPacket);
    }
}

