/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.timetask;

import ch.qos.logback.core.util.FileUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.tio.sitexxx.service.model.conf.Avatar;
import org.tio.sitexxx.service.service.conf.AvatarService;
import org.tio.utils.hutool.StrUtil;

public class DownloadAvatar {
    public static final List<String> URLS = new ArrayList<String>(10000);
    private static final String DOWNLOAD_URL = "https://www.woyaogexing.com/touxiang/z/wxkatong/index_2.html";
    private static final String TYPE = "wxkatong2";
    private static final String savePath = "e:/download/avatar/wxkatong2/";
    private static final Log log = LogFactory.getLog(DownloadAvatar.class);

    public static void main(String[] args) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new DownloadAvatar().download();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }).start();
    }

    public static String nextUrl() {
        if (URLS.size() == 0) {
            return "https://t-io.org/img/case/nb.png";
        }
        return URLS.get(RandomUtil.randomInt((int)0, (int)URLS.size()));
    }

    private void download() throws Exception {
        String html = null;
        String[] imgUrls = null;
        File file = new File(savePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        html = this.getHtml(DOWNLOAD_URL);
        List<String> urls = this.parseUrl(html);
        for (String url : urls) {
            try {
                html = this.getHtml(url);
                imgUrls = this.parseImgUrl(html);
                new Thread(new DownloadImgThread(imgUrls)).start();
            }
            catch (Exception e) {
                log.error((Object)("\u51fa\u9519\u4e86\uff0cURL\uff1a" + url), (Throwable)e);
            }
        }
    }

    private List<String> parseUrl(String html) {
        log.info((Object)"\u6b63\u5728\u5206\u6790\u56fe\u50cf\u5730\u5740...");
        if (html == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)html);
        Elements imgElements = doc.select(".txList a");
        ArrayList<String> urls = new ArrayList<String>(imgElements.size());
        for (int i = 0; i < imgElements.size(); ++i) {
            String href = ((Element)imgElements.get(i)).attr("href");
            if (href.startsWith("javascript:") || !href.endsWith(".html")) continue;
            href = "https://www.woyaogexing.com" + href;
            urls.add(href);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHtml(String url) {
        try {
            log.info((Object)("\u6b63\u5728\u83b7\u53d6\u9875\u9762:" + url));
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                httpGet.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36");
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    if (response.getStatusLine().getStatusCode() != 200) return null;
                    HttpEntity entity = response.getEntity();
                    if (entity == null) return null;
                    String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    return string;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)("\u51fa\u9519\u4e86\uff0cURL\uff1a" + url), (Throwable)e);
            return null;
        }
    }

    private String[] parseImgUrl(String html) {
        log.info((Object)"\u6b63\u5728\u5206\u6790\u56fe\u50cf\u5730\u5740...");
        if (html == null) {
            return null;
        }
        Document doc = Jsoup.parse((String)html);
        Elements imgElements = doc.select(".tx-img a img");
        String[] img_urls = new String[imgElements.size()];
        for (int i = 0; i < imgElements.size(); ++i) {
            img_urls[i] = ((Element)imgElements.get(i)).attr("src");
        }
        return img_urls;
    }

    static class DownloadImgThread
    implements Runnable {
        private String[] imgUrls;
        private static final AtomicInteger FILE_NAME_SEQ = new AtomicInteger();

        public DownloadImgThread(String[] imgUrls) {
            this.imgUrls = imgUrls;
        }

        @Override
        public void run() {
            if (this.imgUrls != null) {
                for (String imgUrl : this.imgUrls) {
                    this.downloadImg(imgUrl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadImg(String imgUrl) {
            if (StrUtil.startWith((CharSequence)imgUrl, (CharSequence)"//")) {
                imgUrl = "https:" + imgUrl;
            }
            String path = URLUtil.getPath((String)imgUrl);
            String fullpath = FilenameUtils.getFullPath((String)path);
            path = fullpath + FILE_NAME_SEQ.incrementAndGet() + "." + FilenameUtils.getExtension((String)path);
            try {
                URLS.add(imgUrl);
            }
            catch (Exception e1) {
                log.error((Object)e1.toString(), (Throwable)e1);
            }
            log.info((Object)("\u6b63\u5728\u4e0b\u8f7d\u5934\u50cf\u5e93\uff1a" + imgUrl));
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).build();
            HttpGet httpGet = new HttpGet(imgUrl);
            httpGet.setConfig(requestConfig);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    HttpEntity entity;
                    if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                        File f = new File(DownloadAvatar.savePath, path);
                        FileUtil.createMissingParentDirectories((File)f);
                        entity.writeTo((OutputStream)new FileOutputStream(f));
                        log.info((Object)("\u4fdd\u5b58\u56fe\u7247\u5230\uff1a" + f.getPath()));
                        Avatar avatar = new Avatar();
                        avatar.setInitUrl(imgUrl);
                        avatar.setPath(path);
                        avatar.setType(DownloadAvatar.TYPE);
                        try {
                            AvatarService.me.save(avatar);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Thread.sleep(800L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

