/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.ws;

import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.HandshakeReq;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.PacketDispatcher;
import org.tio.sitexxx.im.server.handler.wx.WxHandshakeReqHandler;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.MobileInfo;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class ImWsMsgHandler
implements IWsMsgHandler {
    private static Logger log = LoggerFactory.getLogger(ImWsMsgHandler.class);
    private static final int COMMAND_LENGTH = 5;
    private PacketDispatcher packetDispatcher = null;

    public ImWsMsgHandler(PacketDispatcher packetDispatcher) {
        this.packetDispatcher = packetDispatcher;
    }

    public HttpResponse handshake(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        boolean allowAccess = ImUtils.isAllowAccessWs(request, httpResponse, channelContext);
        if (!allowAccess) {
            return null;
        }
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        String is_wx = request.getParam("wx");
        if ("1".equals(is_wx)) {
            imSessionContext.setWx(true);
        }
        String token = request.getParam(Const.Http.SESSION_COOKIE_NAME);
        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCid("pc");
        mobileInfo.setImei("1");
        mobileInfo.setDeviceinfo(request.getHeader("user-agent"));
        mobileInfo.setDevicetype(Devicetype.PC.getValue());
        HandshakeReq handshakeReq = new HandshakeReq();
        handshakeReq.setToken(token);
        handshakeReq.setSign("");
        handshakeReq.setMobileInfo(mobileInfo);
        if (!imSessionContext.isWx()) {
            Tio.remove((ChannelContext)channelContext, (String)"\u4e0d\u652f\u6301\u975ewx\u63e1\u624b");
            return null;
        }
        ImPacket imPacket = new ImPacket(Command.WxHandshakeReq, (Object)handshakeReq);
        WxHandshakeReqHandler.me.handler(imPacket, channelContext, true);
        return httpResponse;
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        String text = ByteBufferUtils.getUtf8((byte[])bytes);
        return this.onText(wsRequest, text, channelContext);
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Tio.remove((ChannelContext)channelContext, (String)"receive close flag");
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) throws Exception {
        ImPacket imPacket = ImWsMsgHandler.toImPacket(wsRequest, channelContext);
        if (imPacket != null) {
            this.packetDispatcher.dispatch(imPacket, channelContext, true);
        }
        return null;
    }

    public static ImPacket toImPacket(WsRequest wsRequest, ChannelContext channelContext) {
        int len;
        if (wsRequest.isHandShake()) {
            ImPacket imPacket = new ImPacket(Command.WxHandshakeReq);
            return imPacket;
        }
        String text = null;
        Opcode opcode = wsRequest.getWsOpcode();
        if (opcode == Opcode.PONG) {
            ImPacket imPacket = new ImPacket(Command.HeartbeatReq);
            return imPacket;
        }
        if (wsRequest.getWsBodyText() == null && wsRequest.getBody() != null) {
            try {
                text = new String(wsRequest.getBody(), "utf-8");
                wsRequest.setWsBodyText(text);
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
            }
        } else {
            text = wsRequest.getWsBodyText();
        }
        if ((len = text.length()) < 5) {
            Tio.remove((ChannelContext)channelContext, (String)"\u6d88\u606f\u957f\u5ea6\u5c0f\u4e8e5");
            return null;
        }
        String commandValueStr = StrUtil.sub((CharSequence)text, (int)0, (int)5);
        short commandValue = 0;
        try {
            commandValue = Short.parseShort(commandValueStr);
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            Tio.remove((ChannelContext)channelContext, (String)"\u6d88\u606f\u524d5\u4f4d\u4e0d\u80fd\u8f6c\u6210short");
            return null;
        }
        Command command = Command.from((Short)commandValue);
        if (command == null) {
            Tio.remove((ChannelContext)channelContext, (String)("\u6d88\u606f\u547d\u4ee4\u7801\u3010" + commandValue + "\u3011\u4e0d\u6b63\u786e"));
            return null;
        }
        ImPacket imPacket = new ImPacket(command);
        String bodyStr = null;
        if (len > 5) {
            bodyStr = StrUtil.subSuf((CharSequence)text, (int)5);
            imPacket.setBodyStr(bodyStr);
        }
        return imPacket;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        Ims.sendHandshake(channelContext);
    }
}

