/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils;

import java.util.Random;

public class BinaryUtils {
    private static final char[] r = "abcdefghijk23456789mnpqrstuvwxy".toCharArray();
    private static final char b = 'z';
    private static final int binLen = r.length;
    private static final int s = 6;

    public static Integer uidIndex(String uid) {
        int[] sushu = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 91, 97, 101, 103, 107, 109, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79};
        int res = 0;
        for (int i = 0; i < uid.length(); ++i) {
            char c = uid.charAt(i);
            if (c >= '0' && c <= '9') {
                res += (c - 48) * sushu[i];
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                res += (c - 97 + 10) * sushu[i];
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                res += (c - 122 + 36) * sushu[i];
                continue;
            }
            res += 1307;
        }
        return res;
    }

    public static String encode(String uid) {
        return BinaryUtils.encode(BinaryUtils.uidIndex(uid));
    }

    public static String encode(int id) {
        char[] buf = new char[32];
        int charPos = 32;
        while (id / binLen > 0) {
            int ind = id % binLen;
            buf[--charPos] = r[ind];
            id /= binLen;
        }
        buf[--charPos] = r[id % binLen];
        String str = new String(buf, charPos, 32 - charPos);
        if (str.length() < 6) {
            StringBuilder sb = new StringBuilder();
            sb.append('z');
            Random rnd = new Random();
            for (int i = 1; i < 6 - str.length(); ++i) {
                sb.append(r[rnd.nextInt(binLen)]);
            }
            str = str + sb.toString();
        }
        return str;
    }

    public static long decode(String code) {
        char[] chs = code.toCharArray();
        long res = 0L;
        for (int i = 0; i < chs.length; ++i) {
            int ind = 0;
            for (int j = 0; j < binLen; ++j) {
                if (chs[i] != r[j]) continue;
                ind = j;
                break;
            }
            if (chs[i] == 'z') break;
            res = i > 0 ? res * (long)binLen + (long)ind : (long)ind;
        }
        return res;
    }
}

