/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.ReadLockHandler;
import org.tio.utils.lock.WriteLockHandler;

public class ObjWithLock<T>
implements Serializable {
    private static final long serialVersionUID = -3048283373239453901L;
    private static Logger log = LoggerFactory.getLogger(ObjWithLock.class);
    private T obj = null;
    private ReentrantReadWriteLock lock = null;

    public ObjWithLock(T obj) {
        this(obj, new ReentrantReadWriteLock());
    }

    public ObjWithLock(T obj, ReentrantReadWriteLock lock) {
        this.obj = obj;
        this.lock = lock;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public T getObj() {
        return this.obj;
    }

    public void setObj(T obj) {
        this.obj = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ReadLockHandler<T> readLockHandler) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            readLockHandler.handler(this.obj);
        }
        catch (Throwable e) {
            log.error("", e);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(WriteLockHandler<T> writeLockHandler) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            writeLockHandler.handler(this.obj);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

