/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.SimpleAttributesEntry;

public class MapAttributes
implements Attributes {
    private final Map<String, EntriesList> map;
    private HashMap<String, Attributes.Entry> entryCache;
    private Collection<Attributes.Entry> entries;
    private Collection<String> values;

    public MapAttributes() {
        this.map = new HashMap<String, EntriesList>();
    }

    public MapAttributes(Map<String, ? extends Collection<String>> original) {
        Assert.checkNotNullParam((String)"original", original);
        HashMap<String, EntriesList> map = new HashMap<String, EntriesList>(original.size());
        for (Map.Entry<String, ? extends Collection<String>> entry : original.entrySet()) {
            map.put(entry.getKey(), new EntriesList((Collection<? extends String>)entry.getValue()));
        }
        this.map = map;
    }

    public MapAttributes(Attributes original) {
        Assert.checkNotNullParam((String)"original", (Object)original);
        HashMap<String, EntriesList> map = new HashMap<String, EntriesList>(original.size());
        for (Attributes.Entry entry : original.entries()) {
            EntriesList entriesList = new EntriesList(entry);
            if (entriesList.isEmpty()) continue;
            map.put(entry.getKey(), entriesList);
        }
        this.map = map;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<String> values() {
        Collection<String> values = this.values;
        if (values != null) {
            return values;
        }
        this.values = Attributes.super.values();
        return this.values;
    }

    @Override
    public Collection<Attributes.Entry> entries() {
        Collection<Attributes.Entry> entries = this.entries;
        if (entries != null) {
            return entries;
        }
        this.entries = new AbstractCollection<Attributes.Entry>(){

            @Override
            public Iterator<Attributes.Entry> iterator() {
                final Iterator iterator = MapAttributes.this.map.keySet().iterator();
                return new Iterator<Attributes.Entry>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Attributes.Entry next() {
                        return MapAttributes.this.get((String)iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MapAttributes.this.size();
            }
        };
        return this.entries;
    }

    @Override
    public int size(String key) {
        EntriesList list = this.map.get(key);
        return list == null ? 0 : list.size();
    }

    @Override
    public boolean remove(String key) {
        return this.map.remove(key) != null;
    }

    @Override
    public void add(String key, int idx, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            list = new EntriesList();
            this.map.put(key, list);
        }
        list.add(idx, value);
    }

    @Override
    public String get(String key, int idx) {
        EntriesList list = this.map.get(key);
        return list == null ? null : (String)list.get(idx);
    }

    @Override
    public String set(String key, int idx, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        return list.set(idx, value);
    }

    @Override
    public String remove(String key, int idx) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        String result = (String)list.remove(idx);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return result;
    }

    @Override
    public List<String> copyAndRemove(String key) {
        EntriesList old = this.map.remove(key);
        return old == null ? new ArrayList(0) : old;
    }

    @Override
    public List<String> copyAndReplace(String key, Collection<String> values) {
        EntriesList old = this.map.replace(key, new EntriesList((Collection<? extends String>)values));
        return old == null ? new ArrayList(0) : old;
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(String key, String value) {
        EntriesList list = this.map.get(key);
        return list != null && list.contains(value);
    }

    @Override
    public void removeRange(String key, int from, int to) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        list.removeRange(from, to);
    }

    @Override
    public int indexOf(String key, String value) {
        EntriesList list = this.map.get(key);
        return list == null ? -1 : list.indexOf(value);
    }

    @Override
    public int lastIndexOf(String key, String value) {
        EntriesList list = this.map.get(key);
        return list == null ? -1 : list.lastIndexOf(value);
    }

    @Override
    public boolean set(String key, int idx, String expect, String update) {
        EntriesList list = this.map.get(key);
        if (list == null || !((String)list.get(idx)).equals(expect)) {
            return false;
        }
        list.set(idx, update);
        return true;
    }

    @Override
    public String getFirst(String key) {
        EntriesList list = this.map.get(key);
        return list == null ? null : (String)list.get(0);
    }

    @Override
    public String getLast(String key) {
        EntriesList list = this.map.get(key);
        return list == null ? null : (String)list.get(list.size() - 1);
    }

    @Override
    public void addFirst(String key, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            list = new EntriesList();
            this.map.put(key, list);
        }
        list.add(0, value);
    }

    @Override
    public void addLast(String key, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            list = new EntriesList();
            this.map.put(key, list);
        }
        list.add(value);
    }

    @Override
    public boolean removeFirst(String key, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            return false;
        }
        int idx = list.indexOf(value);
        if (idx == -1) {
            return false;
        }
        list.remove(idx);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return true;
    }

    @Override
    public boolean removeLast(String key, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            return false;
        }
        int idx = list.lastIndexOf(value);
        if (idx == -1) {
            return false;
        }
        list.remove(idx);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return true;
    }

    @Override
    public String removeFirst(String key) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            return null;
        }
        String removed = (String)list.remove(0);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return removed;
    }

    @Override
    public String removeLast(String key) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            return null;
        }
        String removed = (String)list.remove(list.size() - 1);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return removed;
    }

    @Override
    public boolean remove(String key, int idx, String value) {
        EntriesList list = this.map.get(key);
        if (list == null) {
            return false;
        }
        if (!((String)list.get(idx)).equals(value)) {
            return false;
        }
        list.remove(idx);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return true;
    }

    @Override
    public boolean removeAll(String key, String value) {
        EntriesList list = this.map.get(key);
        return list != null && list.removeAll(Collections.singleton(value));
    }

    @Override
    public Attributes.Entry get(String key) {
        HashMap<String, Attributes.Entry> entryCache = this.entryCache;
        if (entryCache == null) {
            entryCache = this.entryCache = new HashMap();
        }
        return entryCache.computeIfAbsent(key, s -> new SimpleAttributesEntry(this, (String)s));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    static final class EntriesList
    extends ArrayList<String>
    implements Set<String> {
        private static final long serialVersionUID = 8113580421577650775L;

        EntriesList(int initialCapacity) {
            super(initialCapacity);
        }

        EntriesList() {
        }

        EntriesList(Collection<? extends String> c) {
            super(c);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

