/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.TransactionBase;

public class Transaction
extends TransactionBase {
    private final Jedis jedis;

    public Transaction(Jedis jedis) {
        super(jedis.getConnection());
        this.jedis = jedis;
    }

    public Transaction(Connection connection) {
        super(connection);
        this.jedis = null;
    }

    public Transaction(Connection connection, boolean doMulti) {
        super(connection, doMulti);
        this.jedis = null;
    }

    public Transaction(Connection connection, boolean doMulti, boolean closeConnection) {
        super(connection, doMulti, closeConnection);
        this.jedis = null;
    }

    @Override
    protected final void processMultiResponse() {
    }

    @Override
    protected final void processAppendStatus() {
    }

    @Override
    protected final void processPipelinedResponses(int pipelineLength) {
        this.connection.getMany(1 + pipelineLength);
    }

    @Override
    public final List<Object> exec() {
        List<Object> ret;
        try {
            ret = super.exec();
        }
        finally {
            if (this.jedis != null) {
                this.jedis.resetState();
            }
        }
        return ret;
    }

    @Override
    public final String discard() {
        String ret;
        try {
            ret = super.discard();
        }
        finally {
            if (this.jedis != null) {
                this.jedis.resetState();
            }
        }
        return ret;
    }
}

