/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.config;

import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.database.utils.QueryLogUtils;
import java.beans.PropertyVetoException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.flywaydb.core.Flyway;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class DataSourceConfig
implements EnvironmentAware {
    protected Environment env;

    @Resource
    public void setEnvironment(Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean(destroyMethod="close")
    public BasicDataSource dataSource() throws PropertyVetoException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.env.getProperty("jdbc.driver"));
        dataSource.setUrl(this.env.getProperty("jdbc.url"));
        dataSource.setUsername(this.env.getProperty("jdbc.user"));
        dataSource.setPassword(this.env.getProperty("jdbc.password"));
        dataSource.setMaxTotal(((Integer)this.env.getProperty("jdbc.maxActive", Integer.class)).intValue());
        dataSource.setMaxIdle(((Integer)this.env.getProperty("jdbc.maxIdle", Integer.class)).intValue());
        dataSource.setMaxWaitMillis((long)((Integer)this.env.getProperty("jdbc.maxWait", Integer.class)).intValue());
        dataSource.setDefaultAutoCommit((Boolean)this.env.getProperty("jdbc.defaultAutoCommit", Boolean.class));
        dataSource.setRemoveAbandonedTimeout(((Integer)this.env.getProperty("jdbc.removeAbandonedTimeout", Integer.class)).intValue());
        if (StringRegularOpt.isTrue((String)this.env.getProperty("jdbc.show.sql"))) {
            QueryLogUtils.setJdbcShowSql((boolean)true);
        }
        return dataSource;
    }

    @Bean
    public Flyway flyway(DataSource dataSource) {
        String flywayEnable = this.env.getProperty("flyway.enable");
        if (StringRegularOpt.isTrue((String)flywayEnable)) {
            Flyway flywayMigration = new Flyway();
            flywayMigration.setDataSource(dataSource);
            flywayMigration.setBaselineOnMigrate(true);
            flywayMigration.setLocations(new String[]{this.env.getProperty("flyway.sql.dir"), "com.centit.framework.system.update"});
            flywayMigration.migrate();
            return flywayMigration;
        }
        return null;
    }
}

