/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class JdbcTemplateUtils {
    protected static Logger logger = LoggerFactory.getLogger(JdbcTemplateUtils.class);

    public static Object callFunction(JdbcTemplate jdbcTemplate, String procName, int sqlType, Object ... paramObjs) {
        try {
            return jdbcTemplate.execute(conn -> DatabaseAccess.callFunction((Connection)conn, (String)procName, (int)sqlType, (Object[])paramObjs));
        }
        catch (DataAccessException e) {
            throw new PersistenceException(8, (Throwable)e);
        }
    }

    public static final boolean callProcedure(JdbcTemplate jdbcTemplate, String procName, Object ... paramObjs) {
        try {
            return (Boolean)jdbcTemplate.execute(conn -> DatabaseAccess.callProcedure((Connection)conn, (String)procName, (Object[])paramObjs));
        }
        catch (DataAccessException e) {
            throw new PersistenceException(8, (Throwable)e);
        }
    }

    public static final boolean doExecuteSql(JdbcTemplate jdbcTemplate, String sSql) throws DataAccessException {
        jdbcTemplate.execute(sSql);
        return true;
    }

    public static final int doExecuteSql(JdbcTemplate jdbcTemplate, String sSql, Object[] values) throws DataAccessException {
        return jdbcTemplate.update(sSql, values);
    }

    public static final int doExecuteNamedSql(JdbcTemplate jdbcTemplate, String sSql, Map<String, Object> values) throws DataAccessException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)new QueryAndNamedParams(sSql, values));
        return JdbcTemplateUtils.doExecuteSql(jdbcTemplate, qap.getQuery(), qap.getParams());
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Map)namedParams)));
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)namedParams, (String[])fieldNames, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, querySql, fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)namedParams, (String[])fieldNames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> params) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)querySql, (Map)params);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsByNamedSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, querySql, null, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), namedParams, pageDesc);
        }
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, querySql, namedParams);
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Object[])params)));
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldNames, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Object[] params) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldNames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(jdbcTemplate, querySql, fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String queryCountSql, Object[] params, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsBySqlAsJson(jdbcTemplate, querySql, null, queryCountSql, params, pageDesc);
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Object[] params, String[] fieldnames) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldnames);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Object[] params) {
        return (JSONArray)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)querySql, (Object[])params);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONArray listObjectsBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return JdbcTemplateUtils.listObjectsBySqlAsJson(jdbcTemplate, querySql, QueryUtils.buildGetCountSQLByReplaceFields((String)querySql), params, pageDesc);
        }
        return JdbcTemplateUtils.listObjectsBySqlAsJson(jdbcTemplate, querySql, params);
    }

    public static List<Object[]> listObjectsBySql(JdbcTemplate jdbcTemplate, String querySql, Object[] params) {
        return (List)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsBySql((Connection)conn, (String)querySql, (Object[])params);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static List<Object[]> listObjectsBySql(JdbcTemplate jdbcTemplate, String querySql, String queryCountSql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return (List)jdbcTemplate.execute(conn -> {
                try {
                    pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Object[])params)));
                    return DatabaseAccess.findObjectsBySql((Connection)conn, (String)querySql, (Object[])params, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
                }
                catch (IOException | SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            });
        }
        return JdbcTemplateUtils.listObjectsBySql(jdbcTemplate, querySql, params);
    }

    public static List<Object[]> listObjectsBySql(JdbcTemplate jdbcTemplate, String querySql, Object[] params, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            String queryCountSql = QueryUtils.buildGetCountSQL((String)querySql);
            return JdbcTemplateUtils.listObjectsBySql(jdbcTemplate, querySql, queryCountSql, params, pageDesc);
        }
        return JdbcTemplateUtils.listObjectsBySql(jdbcTemplate, querySql, params);
    }

    public static List<Object[]> listObjectsByNamedSql(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> namedParams) {
        return (List)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.findObjectsByNamedSql((Connection)conn, (String)querySql, (Map)namedParams);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static List<Object[]> listObjectsByNamedSql(JdbcTemplate jdbcTemplate, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            return (List)jdbcTemplate.execute(conn -> {
                try {
                    pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)queryCountSql, (Map)namedParams)));
                    return DatabaseAccess.findObjectsByNamedSql((Connection)conn, (String)querySql, (Map)namedParams, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
                }
                catch (IOException | SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            });
        }
        return JdbcTemplateUtils.listObjectsByNamedSql(jdbcTemplate, querySql, namedParams);
    }

    public static List<Object[]> listObjectsByNamedSql(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        if (pageDesc != null && pageDesc.getPageSize() > 0) {
            String queryCountSql = QueryUtils.buildGetCountSQL((String)querySql);
            return JdbcTemplateUtils.listObjectsByNamedSql(jdbcTemplate, querySql, queryCountSql, namedParams, pageDesc);
        }
        return JdbcTemplateUtils.listObjectsByNamedSql(jdbcTemplate, querySql, namedParams);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        Map paramsMap = qap.getParams();
        QueryAndNamedParams countQap = QueryUtils.translateQuery((String)queryCountSql, namedParams);
        paramsMap.putAll(countQap.getParams());
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, qap.getQuery(), fieldNames, countQap.getQuery(), paramsMap, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, qap.getQuery(), fieldNames, QueryUtils.buildGetCountSQLByReplaceFields((String)qap.getQuery()), qap.getParams(), pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String[] fieldNames, Map<String, Object> namedParams) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, qap.getQuery(), fieldNames, qap.getParams());
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, String queryCountSql, Map<String, Object> namedParams, PageDesc pageDesc) {
        return JdbcTemplateUtils.listObjectsByParamsDriverSqlAsJson(jdbcTemplate, querySql, null, queryCountSql, namedParams, pageDesc);
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> namedParams) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, qap.getQuery(), qap.getParams());
    }

    public static JSONArray listObjectsByParamsDriverSqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> namedParams, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, namedParams);
        return JdbcTemplateUtils.listObjectsByNamedSqlAsJson(jdbcTemplate, qap.getQuery(), qap.getParams(), pageDesc);
    }

    public static JSONObject getObjectBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Object[] params, String[] fieldName) {
        return (JSONObject)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql, (Object[])params, (String[])fieldName);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONObject getObjectBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Object[] params) {
        return JdbcTemplateUtils.getObjectBySqlAsJson(jdbcTemplate, querySql, params, null);
    }

    public static JSONObject getObjectBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> params, String[] fieldName) {
        return (JSONObject)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql, (Map)params, (String[])fieldName);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static JSONObject getObjectBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql, Map<String, Object> params) {
        return JdbcTemplateUtils.getObjectBySqlAsJson(jdbcTemplate, querySql, params, null);
    }

    public static JSONObject getObjectBySqlAsJson(JdbcTemplate jdbcTemplate, String querySql) {
        return (JSONObject)jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getObjectAsJSON((Connection)conn, (String)querySql);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(JdbcTemplate jdbcTemplate, String sSql, Map<String, Object> values) {
        return jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Map)values);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(JdbcTemplate jdbcTemplate, String sSql, Object[] values) {
        return jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Object[])values);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(JdbcTemplate jdbcTemplate, String sSql) throws SQLException, IOException {
        return jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Object getScalarObjectQuery(JdbcTemplate jdbcTemplate, String sSql, Object value) throws SQLException, IOException {
        return jdbcTemplate.execute(conn -> {
            try {
                return DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sSql, (Object)value);
            }
            catch (IOException | SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        });
    }

    public static Long getSequenceNextValue(JdbcTemplate jdbcTemplate, String sequenceName) {
        return (Long)jdbcTemplate.execute(conn -> OrmDaoUtils.getSequenceNextValue((Connection)conn, (String)sequenceName));
    }

    public static int batchSaveNewObjects(JdbcTemplate jdbcTemplate, Collection<? extends Object> objects) {
        return (Integer)jdbcTemplate.execute(conn -> {
            int successSaved = 0;
            for (Object o : objects) {
                successSaved += OrmDaoUtils.saveNewObject((Connection)conn, o);
            }
            return successSaved;
        });
    }

    public static int batchUpdateObjects(JdbcTemplate jdbcTemplate, Collection<? extends Object> objects) {
        return (Integer)jdbcTemplate.execute(conn -> {
            int successUpdated = 0;
            for (Object o : objects) {
                successUpdated += OrmDaoUtils.updateObject((Connection)conn, o);
            }
            return successUpdated;
        });
    }

    public static int batchMergeObjects(JdbcTemplate jdbcTemplate, Collection<? extends Object> objects) {
        return (Integer)jdbcTemplate.execute(conn -> {
            int successMerged = 0;
            for (Object o : objects) {
                successMerged += OrmDaoUtils.mergeObject((Connection)conn, o);
            }
            return successMerged;
        });
    }

    public static int batchDeleteObjects(JdbcTemplate jdbcTemplate, Collection<? extends Object> objects) {
        return (Integer)jdbcTemplate.execute(conn -> {
            int successDeleted = 0;
            for (Object o : objects) {
                successDeleted += OrmDaoUtils.deleteObject((Connection)conn, o);
            }
            return successDeleted;
        });
    }

    public static <T> Integer batchUpdateObject(JdbcTemplate jdbcTemplate, Collection<String> fields, T object, Map<String, Object> properties) {
        return (Integer)jdbcTemplate.execute(conn -> OrmDaoUtils.batchUpdateObject((Connection)conn, (Collection)fields, (Object)object, (Map)properties));
    }

    public static <T> Integer batchUpdateObject(JdbcTemplate jdbcTemplate, String[] fields, T object, Map<String, Object> properties) {
        return JdbcTemplateUtils.batchUpdateObject(jdbcTemplate, CollectionsOpt.arrayToList((Object[])fields), object, properties);
    }

    public static Integer batchUpdateObject(JdbcTemplate jdbcTemplate, Class<?> type, Map<String, Object> propertiesValue, Map<String, Object> propertiesFilter) {
        return (Integer)jdbcTemplate.execute(conn -> OrmDaoUtils.batchUpdateObject((Connection)conn, (Class)type, (Map)propertiesValue, (Map)propertiesFilter));
    }
}

