/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.mybatis.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.mybatis.dao.BaseDaoImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseOptUtils {
    public static final int ORACLE_TYPES_CURSOR = -10;
    protected static Logger logger = LoggerFactory.getLogger(DatabaseOptUtils.class);

    private DatabaseOptUtils() {
    }

    public static final void doExecuteSql(SqlSession sqlSession, String sSql) throws SQLException {
        DatabaseAccess.doExecuteSql((Connection)sqlSession.getConnection(), (String)sSql);
    }

    public static final void doExecuteSql(SqlSession sqlSession, String sSql, Object[] values) throws SQLException {
        DatabaseAccess.doExecuteSql((Connection)sqlSession.getConnection(), (String)sSql, (Object[])values);
    }

    public static final void doExecuteSql(SqlSession sqlSession, String sSql, Map<String, Object> values) throws SQLException {
        DatabaseAccess.doExecuteNamedSql((Connection)sqlSession.getConnection(), (String)sSql, values);
    }

    public static final String buildLimitQuerySQL(DBType dbType, String sql, int offset, int maxsize) {
        return QueryUtils.buildLimitQuerySQL((String)sql, (int)offset, (int)maxsize, (boolean)false, (DBType)dbType);
    }

    public static final String getCurrValueOfSequence(SqlSession sqlSession, String sequenceName) throws SQLException, IOException {
        Long seq = DatabaseOptUtils.getNextLongSequence(sqlSession, sequenceName);
        if (seq == null) {
            return null;
        }
        return seq.toString();
    }

    public static final String getNextKeyBySequence(SqlSession sqlSession, String sequenceName, int codeLen) throws SQLException, IOException {
        String sKey = DatabaseOptUtils.getNextValueOfSequence(sqlSession, sequenceName);
        if (codeLen > 0) {
            sKey = StringBaseOpt.fillZeroForString((String)sKey, (int)codeLen);
        }
        return sKey;
    }

    public static Long getSequenceNextValueUseTable(SqlSession sqlSession, String sequenceName) throws SQLException, IOException {
        GeneralJsonObjectDao jsonObjectDao = GeneralJsonObjectDao.createJsonObjectDao((Connection)sqlSession.getConnection());
        return jsonObjectDao.getSimulateSequenceNextValue(sequenceName);
    }

    public static final Long getNextLongSequence(SqlSession sqlSession, String sequenceName) throws SQLException, IOException {
        GeneralJsonObjectDao jsonObjectDao = GeneralJsonObjectDao.createJsonObjectDao((Connection)sqlSession.getConnection());
        return jsonObjectDao.getSequenceNextValue(sequenceName);
    }

    public static final String getNextValueOfSequence(SqlSession sqlSession, String sequenceName) throws SQLException, IOException {
        Long sequence = DatabaseOptUtils.getNextLongSequence(sqlSession, sequenceName);
        if (null == sequence) {
            return "";
        }
        return String.valueOf(sequence);
    }

    public static final Object getSingleObjectBySql(SqlSession sqlSession, String sSql) throws SQLException, IOException {
        return DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql);
    }

    public static final Object getSingleObjectBySql(SqlSession sqlSession, String sSql, Object paramObject) throws SQLException, IOException {
        return DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, (Object)paramObject);
    }

    public static final Object getSingleObjectBySql(SqlSession sqlSession, String sSql, Object[] paramObjects) throws SQLException, IOException {
        return DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, (Object[])paramObjects);
    }

    public static final Object getSingleObjectBySql(SqlSession sqlSession, String sSql, String paramName, Object paramObject) throws SQLException, IOException {
        return DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{paramName, paramObject}));
    }

    public static final Object getSingleObjectBySql(SqlSession sqlSession, String sSql, Map<String, Object> paramObjects) throws SQLException, IOException {
        return DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, paramObjects);
    }

    public static final long getSingleIntBySql(SqlSession sqlSession, String sSql) throws SQLException, IOException {
        Object obj = DatabaseOptUtils.getSingleObjectBySql(sqlSession, sSql);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public static final long getSingleIntBySql(SqlSession sqlSession, String sSql, Object paramObject) throws SQLException, IOException {
        Object obj = DatabaseOptUtils.getSingleObjectBySql(sqlSession, sSql, paramObject);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    public static final String getSingleStringBySql(SqlSession sqlSession, String sSql) throws SQLException, IOException {
        Object obj = DatabaseOptUtils.getSingleObjectBySql(sqlSession, sSql);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public static final boolean callProcedure(SqlSession sqlSession, String procName, Object ... paramObjs) {
        try {
            return DatabaseAccess.callProcedure((Connection)sqlSession.getConnection(), (String)procName, (Object[])paramObjs);
        }
        catch (SQLException e) {
            throw new PersistenceException("call procedure : " + procName, e);
        }
    }

    public static final ResultSet callProcedureOutRS(Connection conn, String procName, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{call ");
        procDesc.append(procName).append("(");
        for (int i = 1; i < n; ++i) {
            procDesc.append("?,");
        }
        procDesc.append("?)}");
        try (CallableStatement stmt = conn.prepareCall(procDesc.toString());){
            DatabaseAccess.setQueryStmtParameters((PreparedStatement)stmt, (Object[])paramObjs);
            stmt.registerOutParameter(n + 1, -10);
            stmt.execute();
            ResultSet resultSet = (ResultSet)stmt.getObject(n + 1);
            return resultSet;
        }
    }

    public static final ResultSet callProcedureOutRS(SqlSession sqlSession, String procName, Object ... paramObjs) throws SQLException {
        return DatabaseOptUtils.callProcedureOutRS(sqlSession.getConnection(), procName, paramObjs);
    }

    public static final Object callFunction(SqlSession sqlSession, String procName, int resultType, Object ... paramObjs) {
        try {
            return DatabaseAccess.callFunction((Connection)sqlSession.getConnection(), (String)procName, (int)resultType, (Object[])paramObjs);
        }
        catch (SQLException e) {
            throw new PersistenceException("call procedure : " + procName, e);
        }
    }

    public static final List<Object[]> findObjectsBySql(SqlSession sqlSession, String sSql) throws SQLException, IOException {
        return DatabaseAccess.findObjectsBySql((Connection)sqlSession.getConnection(), (String)sSql);
    }

    public static final <T> List<T> findObjectsBySql(SqlSession sqlSession, String ssql, Class<T> objectType) {
        BaseDaoImpl mapper = new BaseDaoImpl(sqlSession);
        return mapper.selectList(ssql, objectType);
    }

    public static final int getSqlReturnObjectCounts(SqlSession sqlSession, String sSql, Object[] values) throws SQLException, IOException {
        Object obj = DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, (Object[])values);
        return Integer.valueOf(obj.toString());
    }

    public static final int getSqlReturnObjectCounts(SqlSession sqlSession, String sSql, Map<String, Object> values) throws SQLException, IOException {
        Object obj = DatabaseAccess.getScalarObjectQuery((Connection)sqlSession.getConnection(), (String)sSql, values);
        return Integer.valueOf(obj.toString());
    }

    public static final List<?> findObjectsBySql(SqlSession sqlSession, String ssql, Map<String, Object> values, PageDesc pageDesc, Class<?> objectType) {
        String pageSql;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
            pageSql = DatabaseOptUtils.buildLimitQuerySQL(DBType.mapDBType((Connection)sqlSession.getConnection()), ssql, startPos, maxSize);
        } else {
            pageSql = ssql;
        }
        BaseDaoImpl mapper = new BaseDaoImpl(sqlSession);
        List<Map<String, Object>> listT = null;
        listT = objectType == null ? mapper.selectList(pageSql, values) : mapper.selectList(pageSql, values, objectType);
        if (listT != null && pageDesc != null) {
            if (maxSize > 0) {
                List<Map<String, Object>> rowSumMap = mapper.selectList(QueryUtils.buildGetCountSQL((String)ssql), values);
                if (rowSumMap != null && rowSumMap.size() > 0) {
                    pageDesc.setTotalRows(Integer.valueOf(rowSumMap.get(0).get("rowcount").toString()));
                } else {
                    pageDesc.setTotalRows(Integer.valueOf(listT.size()));
                }
            } else {
                pageDesc.setTotalRows(Integer.valueOf(listT.size()));
            }
        }
        return listT;
    }

    public static final List<?> findObjectsBySql(SqlSession sqlSession, String ssql, Map<String, Object> values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsBySql(sqlSession, ssql, values, pageDesc, null);
    }

    public static final List<?> findObjectsBySql(SqlSession sqlSession, String shql, Map<String, Object> values) {
        return DatabaseOptUtils.findObjectsBySql(sqlSession, shql, values, new PageDesc(-1, -1), null);
    }

    public static final JSONArray findObjectsAsJSONBySql(SqlSession sqlSession, String ssql, String[] fieldnames, Map<String, Object> values, PageDesc pageDesc) {
        List<?> dataList = DatabaseOptUtils.findObjectsBySql(sqlSession, ssql, values, pageDesc, null);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        String[] fieldNames = fieldnames;
        if (fieldNames == null) {
            List fields = QueryUtils.getSqlFiledNames((String)ssql);
            if (fields == null || fields.size() < 1) {
                return null;
            }
            fieldNames = DatabaseAccess.mapColumnsNameToFields((List)fields);
        }
        JSONArray ja = new JSONArray();
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldNames.length; ++i) {
                jo.put(fieldNames[i], DatabaseAccess.fetchLobField((Object)((Object[])dataList.get(j))[i], (boolean)false));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static final JSONArray findObjectsAsJSONBySql(SqlSession sqlSession, String ssql, String[] fieldNames) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(sqlSession, ssql, fieldNames, null, new PageDesc(-1, -1));
    }

    public static final JSONArray findObjectsAsJSONBySql(SqlSession sqlSession, String shql, Map<String, Object> values, PageDesc pageDesc) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(sqlSession, shql, null, values, pageDesc);
    }

    public static final JSONArray findObjectsAsJSONBySql(SqlSession sqlSession, String ssql) {
        return DatabaseOptUtils.findObjectsAsJSONBySql(sqlSession, ssql, null, null, new PageDesc(-1, -1));
    }

    public static final void flush(SqlSession dbSession) {
        dbSession.clearCache();
    }
}

