/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.po.OptMethod;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optMethodDao")
public class OptMethodDaoImpl
extends BaseDaoImpl<OptMethod, String>
implements OptMethodDao {
    @Transactional
    public List<OptMethod> listOptMethodByOptID(String sOptID) {
        return this.listObjects("FROM OptMethod WHERE optId =?", sOptID);
    }

    @Transactional
    public List<OptMethod> listOptMethodByRoleCode(String roleCode) {
        return this.listObjects("FROM OptMethod WHERE optCode in (select id.optCode from RolePower where id.roleCode = ?) order by optId", roleCode);
    }

    @Transactional
    public void deleteOptMethodsByOptID(String sOptID) {
        DatabaseOptUtils.doExecuteHql((BaseDaoImpl)this, (String)"DELETE FROM OptMethod WHERE optId = ?", (Object)sOptID);
    }

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("OPTID", "EQUAL");
            this.filterField.put("PREOPTID", "EQUAL");
            this.filterField.put("ISINTOOLBAR", "EQUAL");
            this.filterField.put("TOPOPTID", "EQUAL");
            this.filterField.put("OPTTYPE", "EQUAL");
            this.filterField.put("OPTNAME", "LIKE");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextOptCode() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_OPTDEFCODE");
    }

    public void updateOptMethod(OptMethod optMethod) {
        super.updateObject((Serializable)optMethod);
    }
}

