/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.VOptTree;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="roleInfoDao")
public class RoleInfoDaoImpl
extends BaseDaoImpl<RoleInfo, String>
implements RoleInfoDao {
    public String getNextKey() {
        return DatabaseOptUtils.getNextValueOfSequence((BaseDaoImpl)this, (String)"S_ROLECODE");
    }

    @Transactional
    public List<VOptTree> getVOptTreeList() {
        return DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)"FROM VOptTree");
    }

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("ROLECODE", "EQUAL");
            this.filterField.put("publicUnitRole", "(roleType='P' or (roleType='D' and unitCode = :publicUnitRole))");
            this.filterField.put("UNITROLE", "(roleType='P' or (roleType='D' and unitCode = :UNITROLE))");
            this.filterField.put("NP_GLOBAL", "(roleType='G' or roleType='P')");
            this.filterField.put("ROLENAME", "LIKE");
            this.filterField.put("ROLEDESC", "LIKE");
            this.filterField.put("isValid", "EQUAL");
            this.filterField.put("roleType", "EQUAL");
            this.filterField.put("unitCode", "EQUAL");
            this.filterField.put("NP_ALL", "(roleType='F' or roleType='G' or roleType='P')");
            this.filterField.put("roleNameEq", "roleName = :roleNameEq");
            this.filterField.put("(date)createDateBeg", "createDate>= :createDateBeg");
            this.filterField.put("(nextday)createDateEnd", "createDate< :createDateEnd");
        }
        return this.filterField;
    }

    @Transactional
    public List<Object> listRoleOptMethods(String rolecode) {
        String hql = "select new map(def.optName as def_optname, def.optCode as def_optcode) from OptMethod def, RolePower pow where def.optCode = pow.id.optCode and pow.id.roleCode = ?";
        return DatabaseOptUtils.findObjectsByHql((BaseDaoImpl)this, (String)hql, (Object[])new Object[]{rolecode});
    }

    public void updateRole(RoleInfo roleInfo) {
        super.updateObject((Serializable)roleInfo);
    }

    public RoleInfo getRoleByCodeOrName(String roleCodeOrName) {
        List roles = this.listObjects(" From RoleInfo where isValid ='T' and ( roleCode= ? or (( roleType='G' or roleType='P') and roleName = ?))", new Object[]{roleCodeOrName, roleCodeOrName});
        if (roles != null && roles.size() > 0) {
            return (RoleInfo)roles.get(0);
        }
        return null;
    }
}

