/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.hibernateimpl;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userSettingDao")
public class UserSettingDaoImpl
extends BaseDaoImpl<UserSetting, UserSettingId>
implements UserSettingDao {
    public static final Logger logger = LoggerFactory.getLogger(UserSettingDaoImpl.class);

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("userCode", "cid.userCode = :userCode");
            this.filterField.put("paramCode", "cid.paramCode = :paramCode");
            this.filterField.put("paramValue", "LIKE");
            this.filterField.put("paramClass", "LIKE");
            this.filterField.put("paramName", "LIKE");
            this.filterField.put("createDate", "LIKE");
        }
        return this.filterField;
    }

    @Transactional
    public List<UserSetting> getUserSettingsByCode(String userCode) {
        return this.listObjects("From UserSetting where cid.userCode=?", userCode);
    }

    @Transactional
    public List<UserSetting> getUserSettings(String userCode, String optID) {
        return this.listObjects("From UserSetting where cid.userCode=? and optId= ?", new Object[]{userCode, optID});
    }

    @Transactional
    public void saveNewUserSetting(UserSetting us) {
        super.saveNewObject((Serializable)us);
    }

    public void updateUserSetting(UserSetting userSetting) {
        super.updateObject((Serializable)userSetting);
    }

    public List<UserSetting> getAllSettings() {
        return super.listObjectsAll();
    }

    public String getValue(String userCode, String key) {
        String sql = "SELECT PARAM_VALUE FROM F_USERSETTING WHERE USER_CODE = ? AND PARAM_CODE = ?";
        return String.valueOf(DatabaseOptUtils.getSingleObjectByHql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, key}));
    }
}

