/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethodUrlMap;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optInfoDao")
public class OptInfoDaoImpl
extends BaseDaoImpl<OptInfo, String>
implements OptInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optId", "EQUAL");
            this.filterField.put("optUrl", "EQUAL");
            this.filterField.put("optName", "LIKE");
            this.filterField.put("preOptId", "EQUAL");
            this.filterField.put("NP_TOPOPT", "(preOptId is null or preOptId='0')");
            this.filterField.put("optType", "EQUAL");
            this.filterField.put("optTypes", "optType in (:optTypes)");
            this.filterField.put("topOptId", "EQUAL");
            this.filterField.put("isInToolbar", "EQUAL");
        }
        return this.filterField;
    }

    @Transactional
    public List<OptInfo> getMenuFuncByOptUrl() {
        String hql1 = "where OPT_URL='...' order by ORDER_IND ";
        return super.listObjectsByFilter(hql1, (Object[])null);
    }

    @Transactional
    public List<OptInfo> getMenuFuncByUserID(String userCode, String optType) {
        String querySql = "SELECT DISTINCT a.USER_CODE,d.Opt_ID,d.Opt_Name,d.Pre_Opt_ID,d.Form_Code,d.opt_url,d.opt_Route,d.Msg_No,d.Msg_Prm,d.Is_In_ToolBar,d.Img_Index,d.Top_Opt_ID,d.Order_Ind,d.Page_Type,d.Opt_Type,d.flow_code,d.icon,d.height,d.width,d.update_date,d.create_date,d.creator,d.updator FROM f_v_userroles a JOIN f_rolepower b ON a.ROLE_CODE = b.ROLE_CODE JOIN f_optdef c ON b.OPT_CODE = c.OPT_CODE JOIN f_optinfo d ON c.Opt_ID = d.Opt_ID WHERE d.opt_url <> '...' and d.IS_IN_TOOLBAR = 'Y' and a.USER_CODE = ? and d.OPT_TYPE = ? order by d.ORDER_IND ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])new Object[]{userCode, optType}, OptInfo.class));
    }

    @Transactional
    public List<String> listUserDataPowerByOptMethod(String userCode, String optId, String optMethod) {
        String sql = "select OPT_SCOPE_CODES from F_V_USEROPTDATASCOPES where USER_CODE = ? and OPT_ID = ? and OPT_METHOD = ?";
        return this.getJdbcTemplate().queryForList(sql, new Object[]{userCode, optId, optMethod}, String.class);
    }

    @Transactional
    public List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, OptMethodUrlMap.class));
    }

    public List<OptInfo> listObjectByParentOptid(String optId) {
        return this.listObjectsByProperty("preOptId", optId);
    }

    public int countChildrenSum(String optId) {
        return this.pageCount(QueryUtils.createSqlParamsMap((Object[])new Object[]{"preOptId", optId}));
    }

    public OptInfo getObjectById(String optId) {
        return (OptInfo)super.getObjectById((Object)optId);
    }

    public List<OptInfo> listObjectsAll() {
        return super.listObjects();
    }

    public void deleteObjectById(String optId) {
        super.deleteObjectById((Object)optId);
    }

    public List<OptInfo> listMenuByTypes(String ... types) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(2);
        if (types.length == 1) {
            map.put("optType", types);
        } else {
            map.put("optTypes", types);
        }
        return this.listObjects(map);
    }

    public void updateOptInfo(OptInfo optInfo) {
        super.updateObject((Serializable)optInfo);
    }

    public List<OptInfo> listUserAllSubMenu(String userCode, String optType) {
        String querySql = "SELECT DISTINCT a.USER_CODE,d.Opt_ID,d.Opt_Name,d.Pre_Opt_ID,d.Form_Code,d.opt_url,d.opt_Route,d.Msg_No,d.Msg_Prm,d.Is_In_ToolBar,d.Img_Index,d.Top_Opt_ID,d.Order_Ind,d.Page_Type,d.Opt_Type,d.flow_code,d.icon,d.height,d.width,d.update_date,d.create_date,d.creator,d.updator FROM f_v_userroles a JOIN f_rolepower b ON a.ROLE_CODE = b.ROLE_CODE JOIN f_optdef c ON b.OPT_CODE = c.OPT_CODE JOIN f_optinfo d ON c.Opt_ID = d.Opt_ID WHERE d.opt_url <> '...' and a.USER_CODE = ? and d.OPT_TYPE = ? order by d.ORDER_IND ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)querySql, (Object[])new Object[]{userCode, optType}, OptInfo.class));
    }
}

