/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.po.OptMethod;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optMethodDao")
public class OptMethodDaoImpl
extends BaseDaoImpl<OptMethod, String>
implements OptMethodDao {
    public OptMethod getObjectById(String optCode) {
        return (OptMethod)super.getObjectById((Object)optCode);
    }

    public void deleteObjectById(String optCode) {
        super.deleteObjectById((Object)optCode);
    }

    @Transactional
    public List<OptMethod> listOptMethodByOptID(String sOptID) {
        return this.listObjectsByProperty("optId", sOptID);
    }

    @Transactional
    public List<OptMethod> listOptMethodByRoleCode(String roleCode) {
        return this.listObjectsByFilter(" WHERE OPT_CODE in (select rp.OPT_CODE from F_ROLEPOWER rp where rp.ROLE_CODE = ?) order by OPT_ID", new Object[]{roleCode});
    }

    @Transactional
    public void deleteOptMethodsByOptID(String sOptID) {
        this.deleteObjectsByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"optId", sOptID}));
    }

    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optId", "EQUAL");
            this.filterField.put("optCode", "EQUAL");
            this.filterField.put("isInWorkflow", "EQUAL");
            this.filterField.put("optReq", "EQUAL");
            this.filterField.put("optMethod", "EQUAL");
            this.filterField.put("optName", "LIKE");
        }
        return this.filterField;
    }

    @Transactional
    public String getNextOptCode() {
        return String.valueOf(DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_OPTDEFCODE"));
    }

    public void updateOptMethod(OptMethod optMethod) {
        super.updateObject((Serializable)optMethod);
    }
}

