/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.VOptTree;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="roleInfoDao")
public class RoleInfoDaoImpl
extends BaseDaoImpl<RoleInfo, String>
implements RoleInfoDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("roleCode", "LIKE");
            this.filterField.put("publicUnitRole", "(ROLE_TYPE='P' or (ROLE_TYPE='D' and UNIT_CODE = :publicUnitRole))");
            this.filterField.put("UNITROLE", "(ROLE_TYPE='P' or (ROLE_TYPE='D' and UNIT_CODE = :UNITROLE))");
            this.filterField.put("NP_GLOBAL", "(ROLE_TYPE='G' or ROLE_TYPE='P')");
            this.filterField.put("roleName", "LIKE");
            this.filterField.put("ROLEDESC", "LIKE");
            this.filterField.put("isValid", "EQUAL");
            this.filterField.put("roleType", "EQUAL");
            this.filterField.put("unitCode", "EQUAL");
            this.filterField.put("NP_ALL", "(ROLE_TYPE='F' or ROLE_TYPE='G' or ROLE_TYPE='P')");
            this.filterField.put("roleNameEq", "ROLE_NAME = :roleNameEq");
            this.filterField.put("(date)createDateBeg", "CREATE_DATE>= :createDateBeg");
            this.filterField.put("(nextday)createDateEnd", "CREATE_DATE< :createDateEnd");
        }
        return this.filterField;
    }

    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_ROLECODE"));
    }

    public List<RoleInfo> listObjectsAll() {
        return super.listObjects();
    }

    public void deleteObjectById(String roleCode) {
        super.deleteObjectById((Object)roleCode);
    }

    public RoleInfo getObjectById(String roleCode) {
        return (RoleInfo)super.getObjectById((Object)roleCode);
    }

    public RoleInfo getRoleByCodeOrName(String roleCodeOrName) {
        List roles = this.listObjectsByFilter(" where IS_VALID ='T' and ( ROLE_CODE= ? or ((ROLE_TYPE='G' or ROLE_TYPE='P') and ROLE_NAME =?))", new Object[]{roleCodeOrName, roleCodeOrName});
        if (roles != null && roles.size() > 0) {
            return (RoleInfo)roles.get(0);
        }
        return null;
    }

    @Transactional
    public List<VOptTree> getVOptTreeList() {
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.listAllObjects((Connection)conn, VOptTree.class));
    }

    @Transactional
    public List<Object> listRoleOptMethods(String rolecode) {
        String hql = "select def.OPT_NAME as def_optname, def.OPT_CODE as def_optcode from F_OPTDEF def, F_ROLEPOWER pow  where def.OPT_CODE = pow.OPT_CODE and pow.ROLE_CODE = ? ";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)hql, (Object[])new Object[]{rolecode});
    }

    @Transactional
    public List<RoleInfo> search(String key, String[] field) {
        HashMap<String, String> filter = new HashMap<String, String>(field.length * 2);
        for (String f : field) {
            filter.put(f, key);
        }
        return this.listObjectsByProperties(filter);
    }

    public RoleInfo getObjectByProperty(String propertyName, Object propertyValue) {
        return (RoleInfo)super.getObjectByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    public void updateRole(RoleInfo roleInfo) {
        super.updateObject((Serializable)roleInfo);
    }
}

