/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.po.RolePower;
import com.centit.framework.system.po.RolePowerId;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="rolePowerDao")
public class RolePowerDaoImpl
extends BaseDaoImpl<RolePower, RolePowerId>
implements RolePowerDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optCode", "EQUAL");
            this.filterField.put("roleCode", "EQUAL");
        }
        return this.filterField;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<RolePower> listObjectsAll() {
        return super.listObjects();
    }

    @Transactional
    public void deleteRolePowersByRoleCode(String roleCode) {
        super.deleteObjectsByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteRolePowersByOptCode(String optCode) {
        super.deleteObjectsByProperties(QueryUtils.createSqlParamsMap((Object[])new Object[]{"optCode", optCode}));
    }

    @Transactional
    public List<RolePower> listRolePowersByRoleCode(String rolecode) {
        return this.listObjectsByProperty("roleCode", rolecode);
    }

    @Transactional
    public void mergeBatchObject(List<RolePower> rolePowers) {
        for (int i = 0; i < rolePowers.size(); ++i) {
            super.mergeObject((Serializable)rolePowers.get(i));
        }
    }

    public void updateRolePower(RolePower rolePower) {
        super.updateObject((Serializable)rolePower);
    }

    public void saveNewRolePower(RolePower rolePower) {
        super.saveNewObject((Serializable)rolePower);
    }

    public void deleteObjectById(RolePowerId id) {
        super.deleteObjectById((Object)id);
    }
}

