/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao.jdbcimpl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.po.OptDataScope;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optDataScopeDao")
public class OptDataScopeDaoImpl
extends BaseDaoImpl<OptDataScope, String>
implements OptDataScopeDao {
    public Map<String, String> getFilterField() {
        if (this.filterField == null) {
            this.filterField = new HashMap();
            this.filterField.put("optId", "EQUAL");
            this.filterField.put("optScopeCode", "EQUAL");
            this.filterField.put("scopeName", "LIKE");
        }
        return this.filterField;
    }

    @Transactional
    public List<OptDataScope> getDataScopeByOptID(String sOptID) {
        return this.listObjectsByProperty("optId", sOptID);
    }

    @Transactional
    public int getOptDataScopeSumByOptID(String sOptID) {
        return this.pageCount(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    @Transactional
    public void deleteDataScopeOfOptID(String sOptID) {
        this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    @Transactional
    public String getNextOptCode() {
        Long nextValue = DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_OPTDEFCODE");
        return nextValue == null ? "" : String.valueOf(nextValue);
    }

    @Transactional
    public List<String> listDataFiltersByIds(Collection<String> scopeCodes) {
        List objs = this.listObjectsByFilter("WHERE OPT_SCOPE_CODE in (:optScopeCode)", CollectionsOpt.createHashMap((Object[])new Object[]{"optScopeCode", scopeCodes}));
        if (objs == null) {
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (OptDataScope scope : objs) {
            filters.add(scope.getFilterCondition());
        }
        return filters;
    }

    public void updateOptDataScope(OptDataScope optDataScope) {
        super.updateObject((Serializable)optDataScope);
    }

    public void saveNewOPtDataScope(OptDataScope optDataScope) {
        super.saveNewObject((Serializable)optDataScope);
    }
}

