/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.model.basedata.IOptMethod;
import com.centit.framework.model.basedata.IRoleInfo;
import com.centit.framework.model.basedata.IRolePower;
import com.centit.framework.model.basedata.IUnitRole;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UnitRoleDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.DataCatalog;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.po.FVUserOptList;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.OptInfo;
import com.centit.framework.system.po.OptMethod;
import com.centit.framework.system.po.RoleInfo;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserSetting;
import com.centit.framework.system.po.UserSettingId;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.security.CentitUserDetailsImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public class DBPlatformEnvironment
implements PlatformEnvironment {
    public static final Logger logger = LoggerFactory.getLogger(DBPlatformEnvironment.class);
    @Resource
    private CentitPasswordEncoder passwordEncoder;
    @Resource
    @NotNull
    private UserSettingDao userSettingDao;
    @Resource
    @NotNull
    private OptInfoDao optInfoDao;
    @Resource
    @NotNull
    private UserInfoDao userInfoDao;
    @Resource
    @NotNull
    private DataDictionaryDao dataDictionaryDao;
    @Resource
    @NotNull
    private DataCatalogDao dataCatalogDao;
    @Resource
    @NotNull
    private UserUnitDao userUnitDao;
    @Resource
    @NotNull
    private UnitInfoDao unitInfoDao;
    @Resource
    @NotNull
    private RoleInfoDao roleInfoDao;
    @Resource
    @NotNull
    private UserRoleDao userRoleDao;
    @Resource
    @NotNull
    private UnitRoleDao unitRoleDao;
    @Resource
    @NotNull
    private OptMethodDao optMethodDao;
    @Resource
    @NotNull
    private RolePowerDao rolePowerDao;

    public void setPasswordEncoder(CentitPasswordEncoder p) {
        this.passwordEncoder = p;
    }

    public void setUserSettingDao(UserSettingDao userSettingDao) {
        this.userSettingDao = userSettingDao;
    }

    public void setOptInfoDao(OptInfoDao optInfoDao) {
        this.optInfoDao = optInfoDao;
    }

    public void setUserInfoDao(UserInfoDao userInfoDao) {
        this.userInfoDao = userInfoDao;
    }

    public void setDataDictionaryDao(DataDictionaryDao dataDictionaryDao) {
        this.dataDictionaryDao = dataDictionaryDao;
    }

    public void setDataCatalogDao(DataCatalogDao dataCatalogDao) {
        this.dataCatalogDao = dataCatalogDao;
    }

    public void setUserUnitDao(UserUnitDao userUnitDao) {
        this.userUnitDao = userUnitDao;
    }

    public void setUnitInfoDao(UnitInfoDao unitInfoDao) {
        this.unitInfoDao = unitInfoDao;
    }

    public void setRoleInfoDao(RoleInfoDao roleInfoDao) {
        this.roleInfoDao = roleInfoDao;
    }

    public void setUserRoleDao(UserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setUnitRoleDao(UnitRoleDao unitRoleDao) {
        this.unitRoleDao = unitRoleDao;
    }

    public void setOptMethodDao(OptMethodDao optMethodDao) {
        this.optMethodDao = optMethodDao;
    }

    public void setRolePowerDao(RolePowerDao rolePowerDao) {
        this.rolePowerDao = rolePowerDao;
    }

    public List<UserSetting> listUserSettings(String userCode) {
        return this.userSettingDao.getUserSettingsByCode(userCode);
    }

    @Transactional(readOnly=true)
    public UserSetting getUserSetting(String userCode, String paramCode) {
        return this.userSettingDao.getObjectById(new UserSettingId(userCode, paramCode));
    }

    @Transactional
    public void saveUserSetting(IUserSetting userSetting) {
        if (StringUtils.equalsAny((CharSequence)userSetting.getParamCode(), (CharSequence[])new CharSequence[]{"regCellPhone", "idCardNo", "regEmail"})) {
            UserInfo ui = this.userInfoDao.getUserByCode(userSetting.getUserCode());
            if (ui == null) {
                return;
            }
            if ("regCellPhone".equals(userSetting.getParamCode())) {
                ui.setRegCellPhone(userSetting.getParamValue());
            } else if ("idCardNo".equals(userSetting.getParamCode())) {
                ui.setIdCardNo(userSetting.getParamValue());
            } else if ("regEmail".equals(userSetting.getParamCode())) {
                ui.setRegEmail(userSetting.getParamValue());
            }
            this.userInfoDao.updateUser(ui);
        } else if (StringUtils.isBlank((CharSequence)userSetting.getParamValue())) {
            this.userSettingDao.deleteObjectById(new UserSettingId(userSetting.getUserCode(), userSetting.getParamCode()));
        } else {
            UserSetting us = this.userSettingDao.getObjectById(new UserSettingId(userSetting.getUserCode(), userSetting.getParamCode()));
            if (us == null) {
                us = new UserSetting();
                us.copyNotNullProperty(userSetting);
                us.setCreateDate(DatetimeOpt.currentUtilDate());
                this.userSettingDao.saveNewUserSetting(us);
            } else {
                us.copyNotNullProperty(userSetting);
                this.userSettingDao.updateUserSetting(us);
            }
        }
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos, String superOptId) {
        if (StringUtils.isEmpty((CharSequence)superOptId)) {
            return Collections.emptyList();
        }
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (StringUtils.equals((CharSequence)superOptId, (CharSequence)optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
            }
        }
        if (parentOpt != null) {
            return parentOpt.getChildren();
        }
        return Collections.emptyList();
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        List preOpts = this.optInfoDao.getMenuFuncByOptUrl();
        String optType = asAdmin ? "S" : "O";
        List ls = this.optInfoDao.getMenuFuncByUserID(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return this.formatMenuTree(menuFunsByUser);
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        List preOpts = this.optInfoDao.getMenuFuncByOptUrl();
        String optType = asAdmin ? "S" : "O";
        List ls = this.optInfoDao.getMenuFuncByUserID(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return this.formatMenuTree(menuFunsByUser, superOptId);
    }

    @Transactional(readOnly=true)
    public List<FVUserRoles> listUserRoles(String userCode) {
        return this.userRoleDao.listUserRolesByUserCode(userCode);
    }

    @Transactional(readOnly=true)
    public List<FVUserRoles> listRoleUsers(String roleCode) {
        return this.userRoleDao.listRoleUsersByRoleCode(roleCode);
    }

    @Transactional(readOnly=true)
    public List<? extends IUnitRole> listUnitRoles(String unitCode) {
        return this.unitRoleDao.listUnitRolesByUnitCode(unitCode);
    }

    @Transactional(readOnly=true)
    public List<? extends IUnitRole> listRoleUnits(String roleCode) {
        return this.unitRoleDao.listUnitRolesByRoleCode(roleCode);
    }

    @Transactional
    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        user.setUserPin(this.passwordEncoder.encodePassword(userPassword, (Object)user.getUserCode()));
        this.userInfoDao.updateUser(user);
    }

    @Transactional(readOnly=true)
    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        return this.passwordEncoder.isPasswordValid(user.getUserPin(), userPassword, (Object)user.getUserCode());
    }

    @Transactional(readOnly=true)
    public List<UserInfo> listAllUsers() {
        return this.userInfoDao.listObjects();
    }

    @Transactional(readOnly=true)
    public List<UnitInfo> listAllUnits() {
        return this.unitInfoDao.listObjects();
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listAllUserUnits() {
        return this.userUnitDao.listObjectsAll();
    }

    private List<UserUnit> fetchUserUnitXzRank(List<UserUnit> userUnits) {
        if (userUnits != null) {
            for (UserUnit uu : userUnits) {
                IDataDictionary dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)uu.getUserRank());
                if (dd == null || dd.getExtraCode() == null || !StringRegularOpt.isNumber((String)dd.getExtraCode())) continue;
                try {
                    uu.setXzRank(Integer.valueOf(dd.getExtraCode()).intValue());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    uu.setXzRank(100000);
                }
            }
        }
        return userUnits;
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listUserUnits(String userCode) {
        return this.fetchUserUnitXzRank(this.userUnitDao.listUserUnitsByUserCode(userCode));
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listUnitUsers(String unitCode) {
        return this.fetchUserUnitXzRank(this.userUnitDao.listUnitUsersByUnitCode(unitCode));
    }

    @Transactional(readOnly=true)
    public List<? extends IRoleInfo> listAllRoleInfo() {
        return this.roleInfoDao.listObjectsAll();
    }

    @Transactional(readOnly=true)
    public List<? extends IRolePower> listAllRolePower() {
        return this.rolePowerDao.listObjectsAll();
    }

    @Transactional(readOnly=true)
    public List<? extends IOptInfo> listAllOptInfo() {
        return this.optInfoDao.listObjectsAll();
    }

    @Transactional(readOnly=true)
    public List<? extends IOptMethod> listAllOptMethod() {
        return this.optMethodDao.listObjectsAll();
    }

    @Transactional(readOnly=true)
    public List<DataCatalog> listAllDataCatalogs() {
        return this.dataCatalogDao.listObjects();
    }

    @Transactional(readOnly=true)
    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return this.dataDictionaryDao.listDataDictionary(catalogCode);
    }

    private CentitUserDetailsImpl fillUserDetailsField(UserInfo userinfo) {
        List usun = this.userUnitDao.listUserUnitsByUserCode(userinfo.getUserCode());
        CentitUserDetailsImpl sysuser = new CentitUserDetailsImpl(userinfo);
        sysuser.setUserUnits(usun);
        for (UserUnit uu : usun) {
            if (!"T".equals(uu.getIsPrimary())) continue;
            sysuser.setCurrentStationId(uu.getUserUnitId());
            break;
        }
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("public", "general public", "G", "G", "T", "general public"));
        List userRolesList = this.userRoleDao.listUserRolesByUserCode(userinfo.getUserCode());
        if (userRolesList != null) {
            for (FVUserRoles role : userRolesList) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)role, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        sysuser.setAuthoritiesByRoles(roles);
        List uoptlist = this.userInfoDao.getAllOptMethodByUser(userinfo.getUserCode());
        HashMap<String, String> userOptList = new HashMap<String, String>();
        if (uoptlist != null) {
            for (FVUserOptList opt : uoptlist) {
                if (StringUtils.isBlank((CharSequence)opt.getOptMethod())) continue;
                userOptList.put(opt.getOptId() + "-" + opt.getOptMethod(), opt.getOptMethod());
            }
        }
        sysuser.setUserOptList(userOptList);
        List uss = this.userSettingDao.getUserSettingsByCode(userinfo.getUserCode());
        if (uss != null) {
            for (UserSetting us : uss) {
                sysuser.putUserSettingsParams(us.getParamCode(), us.getParamValue());
            }
        }
        return sysuser;
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByLoginName(String loginName) {
        UserInfo userinfo = this.userInfoDao.getUserByLoginName(loginName);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByUserCode(String userCode) {
        UserInfo userinfo = this.userInfoDao.getUserByCode(userCode);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByRegEmail(String regEmail) {
        UserInfo userinfo = this.userInfoDao.getUserByRegEmail(regEmail);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetailsImpl loadUserDetailsByRegCellPhone(String regCellPhone) {
        UserInfo userinfo = this.userInfoDao.getUserByRegCellPhone(regCellPhone);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public void updateUserInfo(IUserInfo userInfo) {
        UserInfo ui = this.userInfoDao.getUserByCode(userInfo.getUserCode());
        if (ui == null) {
            return;
        }
        ui.copyNotNullProperty(userInfo);
        this.userInfoDao.updateUser(ui);
    }

    public static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<OptInfo> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (OptInfo opt : ls) {
            opts.add(opt);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opt.getPreOptId() == null || !opt.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int i4;
            int nestedMenu = 0;
            for (i4 = 0; i4 < preOpts.size(); ++i4) {
                isNeeds2[i4] = false;
            }
            block6: for (i4 = 0; i4 < needAdd.size(); ++i4) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i4)).getPreOptId() == null || !((OptInfo)needAdd.get(i4)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i4 = 0;
            while (true) {
                if (i4 >= preOpts.size()) continue block4;
                if (isNeeds2[i4]) {
                    needAdd.add(preOpts.get(i4));
                }
                ++i4;
            }
            break;
        }
        for (i = 0; i < preOpts.size(); ++i) {
            if (!isNeeds[i]) continue;
            opts.add(preOpts.get(i));
        }
        return opts;
    }

    @Transactional
    public void insertOrUpdateMenu(List<? extends IOptInfo> optInfos, List<? extends IOptMethod> optMethods) {
        ArrayList dbMethods = new ArrayList();
        for (OptInfo optInfo : optInfos) {
            if (StringUtils.isEmpty((CharSequence)optInfo.getPreOptId())) {
                optInfo.setPreOptId("0");
            }
            optInfo.setOptType("O");
            optInfo.setCreator("import");
            OptInfo dbOptInfo = this.optInfoDao.getObjectById(optInfo.getOptId());
            if (dbOptInfo == null) {
                optInfo.setCreateDate(new Date());
                this.optInfoDao.saveNewObject(optInfo);
            } else {
                dbOptInfo.copy(optInfo);
                dbOptInfo.setUpdateDate(new Date());
                this.optInfoDao.updateOptInfo(dbOptInfo);
            }
            dbMethods.addAll(this.optMethodDao.listOptMethodByOptID(optInfo.getOptId()));
        }
        Triple triple = CollectionsOpt.compareTwoList(dbMethods, optMethods, (o1, o2) -> StringUtils.compare((String)(o1.getOptId() + o1.getOptMethod()), (String)(o2.getOptId() + o2.getOptMethod())));
        if (triple.getLeft() != null && ((List)triple.getLeft()).size() > 0) {
            for (OptMethod om : (List)triple.getLeft()) {
                if (StringUtils.isEmpty((CharSequence)om.getOptReq())) {
                    om.setOptReq("CRUD");
                }
                om.setOptCode(this.optMethodDao.getNextOptCode());
                this.optMethodDao.saveNewObject(om);
            }
        }
        if (triple.getMiddle() != null && ((List)triple.getMiddle()).size() > 0) {
            for (Pair p : (List)triple.getMiddle()) {
                OptMethod oldMethod = (OptMethod)p.getLeft();
                OptMethod newMethod = (OptMethod)p.getRight();
                newMethod.setOptCode(oldMethod.getOptCode());
                oldMethod.copy(newMethod);
                this.optMethodDao.updateOptMethod(oldMethod);
            }
        }
        if (triple.getRight() != null && ((List)triple.getRight()).size() > 0) {
            for (OptMethod om : (List)triple.getRight()) {
                this.optMethodDao.deleteObject(om);
            }
        }
    }
}

