/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.DataPowerFilter;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.UserQueryFilterDao;
import com.centit.framework.system.po.UserQueryFilter;
import com.centit.framework.system.service.GeneralService;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="generalService")
public class GeneralServiceImpl
implements GeneralService {
    @Resource(name="optInfoDao")
    @NotNull
    protected OptInfoDao optInfoDao;
    @Resource(name="optDataScopeDao")
    @NotNull
    protected OptDataScopeDao dataScopeDao;
    @Resource(name="userQueryFilterDao")
    @NotNull
    protected UserQueryFilterDao userQueryFilterDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public UserQueryFilter getUserDefaultFilter(String userCode, String modelCode) {
        if (StringBaseOpt.isNvl((String)userCode) || StringBaseOpt.isNvl((String)modelCode)) {
            return null;
        }
        List filters = this.userQueryFilterDao.listUserDefaultFilterByModle(userCode, modelCode);
        UserQueryFilter userQueryFilter = null;
        if (filters != null && filters.size() > 0) {
            userQueryFilter = (UserQueryFilter)filters.get(0);
        }
        return userQueryFilter;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public UserQueryFilter getUserQueryFilter(Long filterNo) {
        return this.userQueryFilterDao.getObjectById(filterNo);
    }

    @Override
    @Transactional
    public List<String> listUserDataFiltersByOptIDAndMethod(String sUserCode, String sOptId, String sOptMethod) {
        List dataScopes = this.optInfoDao.listUserDataPowerByOptMethod(sUserCode, sOptId, sOptMethod);
        if (dataScopes == null || dataScopes.size() == 0) {
            return null;
        }
        HashSet<String> scopeCodes = new HashSet<String>();
        for (String scopes : dataScopes) {
            String[] codes;
            if (scopes == null || "null".equalsIgnoreCase(scopes) || "all".equalsIgnoreCase(scopes)) {
                return null;
            }
            for (String code : codes = scopes.split(",")) {
                if (code == null || "".equals(code.trim())) continue;
                scopeCodes.add(code.trim());
            }
        }
        if (scopeCodes.size() == 0) {
            return null;
        }
        return this.dataScopeDao.listDataFiltersByIds(scopeCodes);
    }

    @Override
    @Transactional
    public DataPowerFilter createUserDataPowerFilter(CentitUserDetails userDetails) {
        DataPowerFilter dpf = new DataPowerFilter();
        dpf.addSourceData("currentUser", (Object)userDetails.getUserInfo());
        dpf.addSourceData("currentStation", (Object)userDetails.getCurrentStation());
        dpf.addSourceData("primaryUnit", (Object)CodeRepositoryUtil.getUnitInfoByCode((String)userDetails.getUserInfo().getPrimaryUnit()));
        List userUnits = CodeRepositoryUtil.listUserUnits((String)userDetails.getUserCode());
        if (userUnits != null) {
            dpf.addSourceData("userUnits", (Object)userUnits);
            HashMap<String, ArrayList<IUserUnit>> rankUnits = new HashMap<String, ArrayList<IUserUnit>>(5);
            HashMap<String, ArrayList<IUserUnit>> stationUnits = new HashMap<String, ArrayList<IUserUnit>>(5);
            for (IUserUnit uu : userUnits) {
                ArrayList<IUserUnit> rankUnit = (ArrayList<IUserUnit>)rankUnits.get(uu.getUserRank());
                if (rankUnit == null) {
                    rankUnit = new ArrayList<IUserUnit>(4);
                }
                rankUnit.add(uu);
                rankUnits.put(uu.getUserRank(), rankUnit);
                ArrayList<IUserUnit> stationUnit = (ArrayList<IUserUnit>)stationUnits.get(uu.getUserStation());
                if (stationUnit == null) {
                    stationUnit = new ArrayList<IUserUnit>(4);
                }
                stationUnit.add(uu);
                stationUnits.put(uu.getUserStation(), rankUnit);
            }
            dpf.addSourceData("rankUnits", rankUnits);
            dpf.addSourceData("stationUnits", stationUnits);
        }
        dpf.addSourceData("userRoles", (Object)userDetails.getUserRoles());
        return dpf;
    }
}

