/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.common.ListAppendMap;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import com.centit.support.database.utils.TransactionHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class JdbcPlatformEnvironment
extends AbstractStaticPlatformEnvironment {
    private static Log logger = LogFactory.getLog(JdbcPlatformEnvironment.class);
    private DataSourceDescription dataSource;

    public void setDataBaseConnectInfo(String connectURI, String username, String pswd) {
        this.dataSource = new DataSourceDescription(connectURI, username, pswd);
    }

    private <T> List<T> jsonArrayToObjectList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return new ArrayList();
        }
        return jsonArray.toJavaList(clazz, new JSONReader.Feature[0]);
    }

    private void loadConfigFromJdbc() throws SQLException, IOException, DocumentException {
        ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)this.dataSource.getDbType());
        try (Connection conn = DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.dataSource);){
            JSONArray userJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_USER"));
            List<UserInfo> userinfos = this.jsonArrayToObjectList(userJSONArray, UserInfo.class);
            CodeRepositoryCache.userInfoRepo.setFreshData((Object)"all", (Object)new ListAppendMap(userinfos, UserInfo::getUserCode));
            JSONArray optInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_OPTINFO"));
            List<OptInfo> optinfos = this.jsonArrayToObjectList(optInfoJSONArray, OptInfo.class);
            CodeRepositoryCache.optInfoRepo.setFreshData((Object)"all", optinfos);
            JSONArray optDataScopesJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_OPTDATASCOPE"));
            List<OptDataScope> dataScopes = this.jsonArrayToObjectList(optDataScopesJSONArray, OptDataScope.class);
            this.optDataScopes.setFreshData(dataScopes);
            JSONArray optMethodsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_OPTMETHOD"));
            List<OptMethod> optmethods = this.jsonArrayToObjectList(optMethodsJSONArray, OptMethod.class);
            this.allOptMethod.setFreshData(optmethods);
            JSONArray roleInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_ROLEINFO"));
            List<RoleInfo> roleinfos = this.jsonArrayToObjectList(roleInfoJSONArray, RoleInfo.class);
            CodeRepositoryCache.roleInfoRepo.setFreshData((Object)"all", roleinfos);
            JSONArray rolePowerJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_ROLEPOWER"));
            List<RolePower> rolepowers = this.jsonArrayToObjectList(rolePowerJSONArray, RolePower.class);
            this.allRolePower.setFreshData(rolepowers);
            JSONArray userRoleJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_USERROLE"));
            List<UserRole> userroles = this.jsonArrayToObjectList(userRoleJSONArray, UserRole.class);
            this.allUserRoleRepo.setFreshData(userroles);
            JSONArray unitInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_UNITINFO"));
            List<UnitInfo> unitinfos = this.jsonArrayToObjectList(unitInfoJSONArray, UnitInfo.class);
            CodeRepositoryCache.unitInfoRepo.setFreshData((Object)"all", (Object)new ListAppendMap(unitinfos, UnitInfo::getUnitCode));
            JSONArray userUnitJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_USERUNIT"));
            List<UserUnit> userunits = this.jsonArrayToObjectList(userUnitJSONArray, UserUnit.class);
            this.allUserUnitRepo.setFreshData(userunits);
            JSONArray dataCatalogsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_DATACATALOG"));
            List<DataCatalog> datacatalogs = this.jsonArrayToObjectList(dataCatalogsJSONArray, DataCatalog.class);
            JSONArray dataDictionaryJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_DICTIONARY"));
            List<DataDictionary> datadictionaies = this.jsonArrayToObjectList(dataDictionaryJSONArray, DataDictionary.class);
            for (DataCatalog dd : datacatalogs) {
                ArrayList<DataDictionary> dictionaries = new ArrayList<DataDictionary>(20);
                for (DataDictionary data : datadictionaies) {
                    if (!StringUtils.equals((CharSequence)dd.getCatalogCode(), (CharSequence)data.getCatalogCode())) continue;
                    dictionaries.add(data);
                }
                dd.setDataDictionaries(dictionaries);
            }
            this.catalogRepo.setFreshData(datacatalogs);
            JSONArray osInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_OS"));
            List<OsInfo> osInfos = this.jsonArrayToObjectList(osInfoJSONArray, OsInfo.class);
            CodeRepositoryCache.osInfoCache.setFreshData((Object)"all", osInfos);
        }
    }

    protected synchronized void reloadPlatformData() {
        try {
            CodeRepositoryCache.evictAllCache();
            this.loadConfigFromJdbc();
        }
        catch (IOException | SQLException | DocumentException e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        this.organizePlatformData();
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getAppendMap().get(userCode);
        if (ui == null) {
            return;
        }
        String userNewPassword = this.passwordEncoder.encodePassword(userPassword, (Object)userCode);
        try {
            TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSource, conn -> DatabaseAccess.doExecuteSql((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"UPDATE_USER_PASSWORD"), (Object[])new Object[]{userNewPassword, userCode}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

