/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.oa.po.BbsModule;
import com.centit.product.oa.po.BbsPiece;
import com.centit.product.oa.po.BbsScore;
import com.centit.product.oa.po.BbsSubject;
import com.centit.product.oa.service.BbsModuleManager;
import com.centit.product.oa.service.BbsPieceManager;
import com.centit.product.oa.service.BbsScoreManager;
import com.centit.product.oa.service.BbsSubjectManager;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/bbs"})
@Api(tags={"BBS\u64cd\u4f5c\u63a5\u53e3"}, value="BBS\u63a5\u53e3\u7ef4\u62a4")
public class BbsController
extends BaseController {
    @Autowired
    private BbsModuleManager bbsModuleManager;
    @Autowired
    private BbsPieceManager bbsPieceManager;
    @Autowired
    private BbsSubjectManager bbsSubjectManager;
    @Autowired
    private BbsScoreManager bbsScoreManager;

    public String getOptId() {
        return "BbsPiece";
    }

    @PostMapping(value={"/addModule"})
    @ApiOperation(value="\u65b0\u589e\u6a21\u5757\u4fe1\u606f")
    @WrapUpResponseBody
    public void createBbsModule(@RequestBody BbsModule bbsModule, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        bbsModule.setUserCode(userCode);
        this.bbsModuleManager.saveBbsModule(bbsModule);
    }

    @DeleteMapping(value={"/delModule/{moduleId}"})
    @ApiOperation(value="\u5220\u9664\u6a21\u5757\u4fe1\u606f", notes="\u5220\u9664\u6a21\u5757\u4fe1\u606f,\u5e76\u6ca1\u6709\u5220\u9664\u8be5\u6a21\u5757\u6570\u636e\uff0c\u800c\u662f\u628adataValidFlag\u5b57\u6bb5\u6807\u8bb0\u4e3a0\u3002")
    @ApiImplicitParam(name="moduleId", value="\u6a21\u5757ID", required=true, dataType="String")
    @WrapUpResponseBody
    public void delBbsModule(@PathVariable String moduleId) {
        this.bbsModuleManager.deleteBbsModule(moduleId);
    }

    @ApiOperation(value="\u4fee\u6539\u6a21\u5757\u4fe1\u606f", notes="\u4fee\u6539\u6a21\u5757\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u66f4\u65b0\u7684\u6a21\u5757ID", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="bbsModule", value="json\u683c\u5f0f\uff0c\u66f4\u65b0\u7684\u6a21\u5757\u4fe1\u606f\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=BbsModule.class)})
    @PutMapping(value={"/updateModule/{moduleId}"})
    @WrapUpResponseBody
    public void updateBbsModule(@RequestBody BbsModule bbsModule, @PathVariable String moduleId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("moduleId", moduleId);
        params.put("dataValidFlag", "1");
        BbsModule oldBbsModule = (BbsModule)this.bbsModuleManager.getObjectByProperties(params);
        if (null == oldBbsModule) {
            throw new ObjectException("\u627e\u4e0d\u5230\u6a21\u5757ID\u4e3a" + moduleId + "\u7684\u6570\u636e");
        }
        this.bbsModuleManager.updateBbsModule(bbsModule);
    }

    @GetMapping(value={"/getModuleList"})
    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u5206\u9875\u5217\u8868\u4fe1\u606f", notes="\u67e5\u8be2\u6a21\u5757\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @WrapUpResponseBody
    public PageQueryResult<BbsModule> getModuleList(PageDesc pageDesc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataValidFlag", "1");
        List<BbsModule> moduleList = this.bbsModuleManager.getModuleList(params, pageDesc);
        return PageQueryResult.createResultMapDict(moduleList, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/getModuleSubjectList/{moduleId}"})
    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u4e0b\u7684\u8bdd\u9898\u5206\u9875\u5217\u8868", notes="\u67e5\u8be2\u6a21\u5757\u4e0b\u7684\u8bdd\u9898\u5206\u9875\u5217\u8868")
    @ApiImplicitParam(name="moduleId", value="\u6a21\u5757ID", required=true, dataType="String", paramType="path")
    @WrapUpResponseBody
    public PageQueryResult<BbsSubject> getModuleSubjectList(@PathVariable String moduleId, PageDesc pageDesc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("moduleId", moduleId);
        params.put("dataValidFlag", "1");
        List<BbsSubject> bbsSubjects = this.bbsSubjectManager.getModuleSubjectList(params, pageDesc);
        return PageQueryResult.createResultMapDict(bbsSubjects, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/getSubjectList"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bdd\u9898\u5206\u9875\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bdd\u9898\u5206\u9875\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", paramType="query"), @ApiImplicitParam(name="subjectType", paramType="query"), @ApiImplicitParam(name="applicationId", paramType="query"), @ApiImplicitParam(name="optTag", paramType="query"), @ApiImplicitParam(name="optId", paramType="query")})
    @WrapUpResponseBody
    public PageQueryResult<BbsSubject> getSubjectList(PageDesc pageDesc, HttpServletRequest request) {
        Map params = BbsController.collectRequestParameters((HttpServletRequest)request);
        params.put("dataValidFlag", "1");
        List<BbsSubject> bbsSubjects = this.bbsSubjectManager.getModuleSubjectList(params, pageDesc);
        HashMap<String, String> scoreParams = new HashMap<String, String>();
        scoreParams.put("userCode", WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        List scoreList = this.bbsScoreManager.listObjectsByProperties(scoreParams);
        for (BbsSubject bbsSubject : bbsSubjects) {
            for (BbsScore bbsScore : scoreList) {
                if (!bbsSubject.getSubjectId().equals(bbsScore.getSubjectId())) continue;
                bbsSubject.setUserScore(bbsScore.getBbsScore());
            }
            if (bbsSubject.getUserScore() == null) {
                bbsSubject.setUserScore(-1);
            }
            bbsSubject.setPiece(this.bbsPieceManager.getSubjectPieces(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request), bbsSubject.getSubjectId()));
        }
        return PageQueryResult.createResultMapDict(bbsSubjects, (PageDesc)pageDesc);
    }

    @PostMapping(value={"/addSubject"})
    @ApiOperation(value="\u65b0\u589e\u8bdd\u9898\u4fe1\u606f")
    @WrapUpResponseBody
    public void createBbsSubject(@RequestBody BbsSubject bbsSubject, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        bbsSubject.setUserCode(userCode);
        this.bbsSubjectManager.saveBbsSubject(bbsSubject);
    }

    @DeleteMapping(value={"/delBbsSubject/{subjectId}"})
    @ApiOperation(value="\u5220\u9664\u8bdd\u9898\u4fe1\u606f", notes="\u5220\u9664\u8bdd\u9898\u4fe1\u606f,\u5e76\u6ca1\u6709\u5220\u9664\u8be5\u8bdd\u9898\u6570\u636e\uff0c\u800c\u662f\u628adataValidFlag\u5b57\u6bb5\u6807\u8bb0\u4e3a0\u3002")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String")
    @WrapUpResponseBody
    public void delBbsSubject(@PathVariable String subjectId) {
        this.bbsSubjectManager.deleteBbsSubject(subjectId);
    }

    @PostMapping(value={"/addBbsPiece/{subjectId}"})
    @ApiOperation(value="\u6dfb\u52a0\u8bc4\u8bba\u4fe1\u606f")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String")
    @WrapUpResponseBody
    public void createBbsPiece(@RequestBody BbsPiece bbsPiece, @PathVariable String subjectId, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subjectId", subjectId);
        params.put("dataValidFlag", "1");
        BbsSubject bbsSubject = (BbsSubject)this.bbsSubjectManager.getObjectByProperties(params);
        if (null == bbsSubject) {
            throw new ObjectException("\u8bdd\u9898ID\u4e3a" + subjectId + "\u7684\u8bdd\u9898\u4e0d\u5b58\u5728");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        bbsPiece.setUserCode(userCode);
        bbsPiece.setReplyId("0");
        this.bbsPieceManager.saveBbsPiece(bbsPiece);
    }

    @PostMapping(value={"/replyPiece"})
    @ApiOperation(value="\u56de\u590d\u8bc4\u8bba")
    @WrapUpResponseBody
    public void replyPiece(@RequestBody BbsPiece bbsPiece, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pieceId", bbsPiece.getReplyId());
        params.put("dataValidFlag", "1");
        BbsPiece piece = (BbsPiece)this.bbsPieceManager.getObjectByProperties(params);
        if (null == piece) {
            throw new ObjectException("\u8bc4\u8bbaID\u4e3a" + bbsPiece.getReplyId() + "\u7684\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        bbsPiece.setUserCode(userCode);
        this.bbsPieceManager.saveBbsPiece(bbsPiece);
    }

    @GetMapping(value={"/getSubjectPieces/{subjectId}"})
    @ApiOperation(value="\u67e5\u8be2\u8bdd\u9898\u4e0b\u7684\u8bc4\u8bba\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u8bdd\u9898\u4e0b\u7684\u8bc4\u8bba\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String", paramType="path")
    @WrapUpResponseBody
    public List<Map<String, Object>> getSubjectPieces(@PathVariable String subjectId, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.bbsPieceManager.getSubjectPieces(topUnit, subjectId);
    }

    @DeleteMapping(value={"/delBbsPiece/{pieceId}"})
    @ApiOperation(value="\u5220\u9664\u8bc4\u8bba\u4fe1\u606f", notes="\u5220\u9664\u8bc4\u8bba\u4fe1\u606f,\u5e76\u6ca1\u6709\u5220\u9664\u8be5\u8bc4\u8bba\u6570\u636e\uff0c\u800c\u662f\u628adataValidFlag\u5b57\u6bb5\u6807\u8bb0\u4e3a0\u3002")
    @ApiImplicitParam(name="pieceId", value="\u8bc4\u8bbaID", required=true, dataType="String")
    @WrapUpResponseBody
    public void delBbsPiece(@PathVariable String pieceId) {
        this.bbsPieceManager.deleteBbsPiece(pieceId);
    }

    @PostMapping(value={"/subjectScore/{subjectId}"})
    @ApiOperation(value="\u8bdd\u9898\u8bc4\u5206")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String")
    @WrapUpResponseBody
    public void subjectScore(@RequestBody BbsScore bbsScore, @PathVariable String subjectId, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subjectId", subjectId);
        params.put("dataValidFlag", "1");
        BbsSubject bbsSubject = (BbsSubject)this.bbsSubjectManager.getObjectByProperties(params);
        if (null == bbsSubject) {
            throw new ObjectException("\u8bdd\u9898ID\u4e3a" + subjectId + "\u7684\u8bdd\u9898\u4e0d\u5b58\u5728");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("subjectId", subjectId);
        List bbsScores = this.bbsScoreManager.listObjectsByProperties(map);
        if (CollectionUtils.isNotEmpty((Collection)bbsScores)) {
            throw new ObjectException("\u7528\u6237" + bbsScore.getUserCode() + "\u5df2\u7ecf\u5bf9\uff1a" + bbsScore.getSubjectId() + "\u8bc4\u5206\u8fc7\uff01");
        }
        bbsScore.setUserCode(userCode);
        this.bbsScoreManager.saveBbsScore(bbsScore);
    }

    @GetMapping(value={"/getUserSubjectScore/{subjectId}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5bf9\u8bdd\u9898\u7684\u8bc4\u5206\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5bf9\u8bdd\u9898\u7684\u8bc4\u5206\u4fe1\u606f")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String")
    @WrapUpResponseBody
    public BbsScore getUserSubjectScore(@PathVariable String subjectId, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subjectId", subjectId);
        params.put("dataValidFlag", "1");
        BbsSubject bbsSubject = (BbsSubject)this.bbsSubjectManager.getObjectByProperties(params);
        if (null == bbsSubject) {
            throw new ObjectException("\u8bdd\u9898ID\u4e3a" + subjectId + "\u7684\u8bdd\u9898\u4e0d\u5b58\u5728");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.bbsScoreManager.getUserSubjectScore(subjectId, userCode);
    }

    @GetMapping(value={"/isUserScore/{subjectId}"})
    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u662f\u5426\u5bf9\u8bdd\u9898\u8bc4\u5206", notes="\u5f53\u524d\u7528\u6237\u662f\u5426\u5bf9\u8bdd\u9898\u8bc4\u5206")
    @ApiImplicitParam(name="subjectId", value="\u8bdd\u9898ID", required=true, dataType="String")
    @WrapUpResponseBody
    public boolean isUserScore(@PathVariable String subjectId, HttpServletRequest request) {
        boolean result = false;
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userCode", userCode);
        params.put("subjectId", subjectId);
        List bbsScores = this.bbsScoreManager.listObjectsByProperties(params);
        if (CollectionUtils.isNotEmpty((Collection)bbsScores)) {
            result = true;
        }
        return result;
    }
}

