/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.product.oa.dao.BbsModuleDao;
import com.centit.product.oa.po.BbsModule;
import com.centit.product.oa.service.BbsModuleManager;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BbsModuleManagerImpl
extends BaseEntityManagerImpl<BbsModule, String, BbsModuleDao>
implements BbsModuleManager {
    private static Logger logger = LoggerFactory.getLogger(BbsModuleManagerImpl.class);
    private BbsModuleDao bbsModuleDao;

    @Resource(name="bbsModuleDao")
    @NotNull
    public void setBbsModuleDao(BbsModuleDao baseDao) {
        this.bbsModuleDao = baseDao;
        this.setBaseDao(this.bbsModuleDao);
    }

    @Override
    public void saveBbsModule(BbsModule bbsModule) {
        bbsModule.setModuleId(null);
        bbsModule.setDataValidFlag("1");
        this.bbsModuleDao.saveNewObject(bbsModule);
    }

    @Override
    public void deleteBbsModule(String moduleId) {
        if (StringUtils.isBlank((CharSequence)moduleId)) {
            logger.warn("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u7406\uff0c\u8bf7\u91cd\u65b0\u4f20\u5165\uff01");
            return;
        }
        BbsModule bbsModule = (BbsModule)this.bbsModuleDao.getObjectById(moduleId);
        if (null == bbsModule) {
            logger.warn("M_BBS_MODULE\u8868\u4e2d\u6570\u636e\u627e\u4e0d\u5230\u4e3b\u952e\u4e3a" + moduleId + "\u7684\u6570\u636e");
            return;
        }
        bbsModule.setDataValidFlag("0");
        this.bbsModuleDao.updateObject(bbsModule);
    }

    @Override
    public void updateBbsModule(BbsModule bbsModule) {
        this.bbsModuleDao.updateObject(bbsModule);
    }

    @Override
    public List<BbsModule> getModuleList(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.bbsModuleDao.listObjectsByProperties(filterMap, pageDesc);
    }
}

