/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.product.oa.dao.BbsPieceDao;
import com.centit.product.oa.dao.BbsSubjectDao;
import com.centit.product.oa.po.BbsPiece;
import com.centit.product.oa.po.BbsSubject;
import com.centit.product.oa.service.BbsPieceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BbsPieceManagerImpl
extends BaseEntityManagerImpl<BbsPiece, String, BbsPieceDao>
implements BbsPieceManager {
    private static Logger logger = LoggerFactory.getLogger(BbsPieceManagerImpl.class);
    private BbsPieceDao bbsPieceDao;
    @Autowired
    private BbsSubjectDao bbsSubjectDao;

    @Resource(name="bbsPieceDao")
    @NotNull
    public void setBbsModuleDao(BbsPieceDao baseDao) {
        this.bbsPieceDao = baseDao;
        this.setBaseDao(this.bbsPieceDao);
    }

    @Override
    public void saveBbsPiece(BbsPiece bbsPiece) {
        bbsPiece.setPieceId(null);
        bbsPiece.setDataValidFlag("1");
        bbsPiece.setPieceState("N");
        this.bbsPieceDao.saveNewObject(bbsPiece);
        BbsSubject subject = (BbsSubject)this.bbsSubjectDao.getObjectById(bbsPiece.getSubjectId());
        subject.setReplyTimes(subject.getReplyTimes() + 1);
        this.bbsSubjectDao.updateObject(subject);
    }

    @Override
    public void deleteBbsPiece(String pieceId) {
        if (StringUtils.isBlank((CharSequence)pieceId)) {
            logger.warn("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u7406\uff0c\u8bf7\u91cd\u65b0\u4f20\u5165\uff01");
            return;
        }
        BbsPiece bbsPiece = (BbsPiece)this.bbsPieceDao.getObjectById(pieceId);
        if (null == bbsPiece) {
            logger.warn("M_BBS_PIECE\u8868\u4e2d\u6570\u636e\u627e\u4e0d\u5230\u4e3b\u952e\u4e3a" + pieceId + "\u7684\u6570\u636e");
            return;
        }
        bbsPiece.setDataValidFlag("0");
        this.bbsPieceDao.updateObject(bbsPiece);
        BbsSubject subject = (BbsSubject)this.bbsSubjectDao.getObjectById(bbsPiece.getSubjectId());
        subject.setReplyTimes(subject.getReplyTimes() - 1);
        this.bbsSubjectDao.updateObject(subject);
    }

    @Override
    public void updateBbsPiece(BbsPiece bbsPiece) {
        this.bbsPieceDao.updateObject(bbsPiece);
    }

    @Override
    public List<Map<String, Object>> getSubjectPieces(String topUnit, String subjectId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataValidFlag", "1");
        params.put("subjectId", subjectId);
        params.put("replyId", "0");
        List bbsPieces = this.bbsPieceDao.listObjectsByProperties(params);
        if (CollectionUtils.isNotEmpty((Collection)bbsPieces)) {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("dataValidFlag", "1");
            filterMap.put("subjectId", subjectId);
            for (BbsPiece bbsPiece : bbsPieces) {
                bbsPiece.setPublishUserName(CodeRepositoryUtil.getUserName((String)topUnit, (String)bbsPiece.getUserCode()));
                HashMap<String, Object> data = new HashMap<String, Object>();
                String pieceId = bbsPiece.getPieceId();
                filterMap.put("replyId", pieceId);
                List replyInfos = this.bbsPieceDao.listObjectsByProperties(filterMap);
                for (BbsPiece bbsPiece1 : replyInfos) {
                    bbsPiece1.setPublishUserName(CodeRepositoryUtil.getUserName((String)topUnit, (String)bbsPiece1.getUserCode()));
                }
                data.put("bbsPiece", bbsPiece);
                data.put("replyInfos", replyInfos);
                result.add(data);
            }
        }
        return result;
    }
}

