/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.product.oa.dao.BbsScoreDao;
import com.centit.product.oa.dao.BbsSubjectDao;
import com.centit.product.oa.po.BbsScore;
import com.centit.product.oa.po.BbsSubject;
import com.centit.product.oa.service.BbsScoreManager;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BbsScoreManagerImpl
extends BaseEntityManagerImpl<BbsScore, String, BbsScoreDao>
implements BbsScoreManager {
    private static Logger logger = LoggerFactory.getLogger(BbsScoreManagerImpl.class);
    private BbsScoreDao bbsScoreDao;
    @Autowired
    private BbsSubjectDao bbsSubjectDao;

    @Resource(name="bbsScoreDao")
    @NotNull
    public void setBbsScoreDao(BbsScoreDao baseDao) {
        this.bbsScoreDao = baseDao;
        this.setBaseDao(this.bbsScoreDao);
    }

    @Override
    public void saveBbsScore(BbsScore bbsScore) {
        this.bbsScoreDao.saveNewObject(bbsScore);
        BbsSubject subject = (BbsSubject)this.bbsSubjectDao.getObjectById(bbsScore.getSubjectId());
        subject.setReplyTimes(subject.getReplyTimes() + 1);
        subject.setScoreSum(subject.getScoreSum() + bbsScore.getBbsScore());
        this.bbsSubjectDao.updateObject(subject);
    }

    @Override
    public void updateBbsModule(BbsScore bbsScore) {
        this.bbsScoreDao.updateObject(bbsScore);
    }

    @Override
    public String getSubjectScore(String subjectId) {
        return this.bbsScoreDao.getSubjectScore(subjectId);
    }

    @Override
    public BbsScore getUserSubjectScore(String subjectId, String userCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subjectId", subjectId);
        params.put("userCode", userCode);
        return (BbsScore)this.bbsScoreDao.getObjectByProperties(params);
    }
}

