/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.product.oa.dao.BbsSubjectDao;
import com.centit.product.oa.po.BbsSubject;
import com.centit.product.oa.service.BbsSubjectManager;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BbsSubjectManagerImpl
extends BaseEntityManagerImpl<BbsSubject, String, BbsSubjectDao>
implements BbsSubjectManager {
    private static Logger logger = LoggerFactory.getLogger(BbsSubjectManagerImpl.class);
    private BbsSubjectDao bbsSubjectDao;

    @Resource(name="bbsSubjectDao")
    @NotNull
    public void setBbsSubjectDao(BbsSubjectDao baseDao) {
        this.bbsSubjectDao = baseDao;
        this.setBaseDao(this.bbsSubjectDao);
    }

    @Override
    public void saveBbsSubject(BbsSubject bbsSubject) {
        bbsSubject.setSubjectId(null);
        bbsSubject.setDataValidFlag("1");
        bbsSubject.setSubjectState("N");
        this.bbsSubjectDao.saveNewObject(bbsSubject);
    }

    @Override
    public void deleteBbsSubject(String subjectId) {
        if (StringUtils.isBlank((CharSequence)subjectId)) {
            logger.warn("\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u7406\uff0c\u8bf7\u91cd\u65b0\u4f20\u5165\uff01");
            return;
        }
        BbsSubject bbsSubject = (BbsSubject)this.bbsSubjectDao.getObjectById(subjectId);
        if (null == bbsSubject) {
            logger.warn("M_BBS_SUBJECT\u8868\u4e2d\u6570\u636e\u627e\u4e0d\u5230\u4e3b\u952e\u4e3a" + subjectId + "\u7684\u6570\u636e");
            return;
        }
        bbsSubject.setDataValidFlag("0");
        this.bbsSubjectDao.updateObject(bbsSubject);
    }

    @Override
    public void updateBbsModule(BbsSubject bbsSubject) {
        this.bbsSubjectDao.updateObject(bbsSubject);
    }

    @Override
    public List<BbsSubject> getModuleSubjectList(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.bbsSubjectDao.listObjectsByProperties(filterMap, pageDesc);
    }
}

