/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.SourceInfoManager;
import com.centit.product.metadata.transaction.AbstractDBConnectPools;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.HtmlFormUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/database"})
@Api(tags={"\u6570\u636e\u5e93\u7ef4\u62a4\u63a5\u53e3"}, value="\u6570\u636e\u5e93\u7ef4\u62a4\u63a5\u53e3")
public class SourceInfoController
extends BaseController {
    @Autowired
    private SourceInfoManager databaseInfoMag;
    private String optId = "DATABASE";

    @ApiOperation(value="\u6240\u6709\u6570\u636e\u5e93\u5217\u8868\u4fe1\u606f", notes="\u6240\u6709\u6570\u636e\u5e93\u5217\u8868\u4fe1\u606f\u3002\u589e\u52a0databaseCode")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.BASE64)
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return PageQueryResult.createResult(Collections.emptyList(), (PageDesc)pageDesc);
        }
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            searchColumn.put("topUnit", topUnit);
        }
        JSONArray listObjects = this.databaseInfoMag.listDatabaseAsJson(searchColumn, pageDesc);
        this.databaseInfoMag.appendRelativeOsInfo(listObjects);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{SourceInfo.class});
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u4fe1\u606f", notes="\u65b0\u589e\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    public void saveDatabaseInfo(@RequestBody SourceInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)WebOptUtils.getCurrentUserCode((HttpServletRequest)request))) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(500, "\u60a8\u8fd8\u672a\u52a0\u5165\u79df\u6237!");
        }
        databaseinfo.setTopUnit(topUnit);
        databaseinfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)databaseinfo.getDatabaseUrl()));
        if (StringUtils.isNotBlank((CharSequence)databaseinfo.getPassword())) {
            databaseinfo.setPassword(databaseinfo.getPassword());
        }
        databaseinfo.setCreated(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        this.databaseInfoMag.saveNewObject(databaseinfo);
        JsonResultUtils.writeSingleDataJson((Object)databaseinfo.getDatabaseCode(), (HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)databaseinfo.getDatabaseCode(), (String)"create", (String)"\u65b0\u589e\u6570\u636e\u5e93", (Object)databaseinfo);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5", notes="\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5\u3002")
    @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)
    @RequestMapping(value={"/testConnect"}, method={RequestMethod.POST})
    public void testConnect(@Valid SourceInfo sourceInfo, HttpServletResponse response) {
        sourceInfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)sourceInfo.getDatabaseUrl()));
        if (sourceInfo.getDatabaseCode() != null) {
            SourceInfo dataBaseSourceInfo = this.databaseInfoMag.getObjectById(sourceInfo.getDatabaseCode());
            if (dataBaseSourceInfo != null) {
                sourceInfo.setExtProps(dataBaseSourceInfo.getExtProps());
            }
            if (StringBaseOpt.isNvl((String)sourceInfo.getPassword())) {
                sourceInfo.setPassword(dataBaseSourceInfo.getPassword());
            }
        }
        try {
            AbstractDBConnectPools.testConnect(sourceInfo);
            JsonResultUtils.writeSingleDataJson((Object)"\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f", (HttpServletResponse)response);
        }
        catch (SQLException e) {
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="databaseinfo", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=SourceInfo.class)})
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.PUT})
    public void updateDatabaseInfo(@PathVariable String databaseCode, @RequestBody SourceInfo databaseinfo, HttpServletRequest request, HttpServletResponse response) {
        databaseinfo.setDatabaseUrl(HtmlFormUtils.htmlString((String)databaseinfo.getDatabaseUrl()));
        SourceInfo temp = this.databaseInfoMag.getObjectById(databaseCode);
        if (StringUtils.isNotBlank((CharSequence)databaseinfo.getPassword()) && !databaseinfo.getPassword().equals(temp.getPassword())) {
            databaseinfo.setPassword(databaseinfo.getPassword());
        }
        SourceInfo oldValue = new SourceInfo();
        BeanUtils.copyProperties((Object)temp, (Object)oldValue);
        this.databaseInfoMag.mergeObject(databaseinfo);
        if ("D".equals(databaseinfo.getSourceType())) {
            AbstractDBConnectPools.refreshDataSource((ISourceInfo)databaseinfo);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"update", (String)"\u66f4\u65b0\u6570\u636e\u5e93\u4fe1\u606f", (Object)databaseinfo, (Object)oldValue);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f", notes="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.GET})
    public void getDatabaseInhfo(@PathVariable String databaseCode, HttpServletResponse response) {
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(databaseCode);
        JsonResultUtils.writeSingleDataJson((Object)sourceInfo, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f", notes="\u5220\u9664\u5355\u4e2a\u6570\u636e\u5e93\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{databaseCode}"}, method={RequestMethod.DELETE})
    public void deleteDatabase(@PathVariable String databaseCode, HttpServletRequest request, HttpServletResponse response) {
        SourceInfo sourceInfo = this.databaseInfoMag.getObjectById(databaseCode);
        this.databaseInfoMag.deleteObjectById(databaseCode);
        if ("D".equals(sourceInfo.getSourceType())) {
            AbstractDBConnectPools.delDataSource((ISourceInfo)sourceInfo);
        }
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)databaseCode, (String)"delete", (String)"\u5220\u9664\u6570\u636e\u5e93", (Object)sourceInfo);
    }
}

