/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.DictionaryMapColumn;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.dao.DataCheckRuleDao;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.DataCheckRule;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.metadata.service.MetaObjectService;
import com.centit.product.metadata.service.impl.SqlDictionaryMapSupplier;
import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.product.metadata.utils.DataCheckResult;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.CachedObject;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.OrmUtils;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.support.security.Md5Encoder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MetaObjectServiceImpl
implements MetaObjectService {
    @Autowired
    private SourceInfoDao sourceInfoDao;
    @Autowired
    private MetaDataCache metaDataCache;
    @Autowired
    private DataCheckRuleDao dataCheckRuleDao;

    private static Map<String, Object> prepareObjectForSave(Map<String, Object> object, MetaTable metaTable) {
        for (MetaColumn col : metaTable.getMdColumns()) {
            String fieldName = col.getPropertyName();
            Object fieldValue = object.get(fieldName);
            if (fieldValue == null) {
                fieldName = col.getColumnName();
                fieldValue = object.get(fieldName);
            }
            if (fieldValue == null) continue;
            switch (col.getFieldType()) {
                case "date": 
                case "datetime": 
                case "timestamp": {
                    object.put(fieldName, DatetimeOpt.castObjectToSqlTimestamp((Object)fieldValue));
                    break;
                }
                case "integer": 
                case "long": {
                    object.put(fieldName, NumberBaseOpt.castObjectToLong((Object)fieldValue));
                    break;
                }
                case "money": {
                    object.put(fieldName, NumberBaseOpt.castObjectToBigDecimal((Object)fieldValue));
                    break;
                }
                case "float": 
                case "double": {
                    object.put(fieldName, NumberBaseOpt.castObjectToDouble((Object)fieldValue));
                    break;
                }
                case "string": 
                case "text": {
                    object.put(fieldName, StringBaseOpt.castObjectToString((Object)fieldValue));
                    break;
                }
                case "boolean": {
                    object.put(fieldName, BooleanBaseOpt.castObjectToBoolean((Object)fieldValue, (Boolean)false) != false ? "T" : "F");
                    break;
                }
            }
        }
        return object;
    }

    private static void makeObjectValueByGenerator(Map<String, Object> object, Map<String, Object> extParams, MetaTable metaTable, JsonObjectDao sqlDialect, long pkOrder, boolean isGetObject, boolean createNew) throws SQLException, IOException {
        for (MetaColumn field : metaTable.getMdColumns()) {
            if (!StringUtils.equalsAny((CharSequence)field.getAutoCreateRule(), (CharSequence[])new CharSequence[]{"C", "U", "S", "W", "F", "O"}) || !"A".equals(field.getAutoCreateCondition()) && (!createNew || object.get(field.getPropertyName()) != null)) continue;
            switch (field.getAutoCreateRule()) {
                case "U": {
                    object.put(field.getPropertyName(), UuidOpt.getUuidAsString32());
                    break;
                }
                case "S": {
                    if (sqlDialect == null) break;
                    object.put(field.getPropertyName(), sqlDialect.getSequenceNextValue(field.getAutoCreateParam()));
                    break;
                }
                case "C": {
                    object.put(field.getPropertyName(), field.getAutoCreateParam());
                    break;
                }
                case "W": {
                    object.put(field.getPropertyName(), OrmUtils.getDefaultSnowFlakeInstance().nextId());
                    break;
                }
                case "F": {
                    VariableFormula formula = new VariableFormula();
                    formula.addExtendFunc("getSequence", a -> {
                        try {
                            sqlDialect.getSequenceNextValue((String)a[0]);
                        }
                        catch (IOException | SQLException e) {
                            e.printStackTrace();
                        }
                        return null;
                    });
                    formula.setFormula(field.getAutoCreateParam());
                    if (extParams != null) {
                        HashMap<String, Object> objectMap = new HashMap<String, Object>(extParams.size() + object.size() + 2);
                        objectMap.putAll(extParams);
                        objectMap.putAll(object);
                        formula.setTrans((VariableTranslate)new ObjectTranslate(objectMap));
                        object.put(field.getPropertyName(), formula.calcFormula());
                        break;
                    }
                    formula.setTrans((VariableTranslate)new ObjectTranslate(object));
                    object.put(field.getPropertyName(), formula.calcFormula());
                    break;
                }
                case "O": {
                    if (isGetObject) break;
                    int pkCount = metaTable.countPkColumn();
                    if (pkCount < 2 || !field.isPrimaryKey()) {
                        throw new ObjectException(627, "\u4e3b\u952e\u751f\u6210\u89c4\u5219SUB_ORDER\u5fc5\u987b\u7528\u4e8e\u590d\u5408\u4e3b\u952e\u8868\u4e2d\uff0c\u5e76\u4e14\u53ea\u80fd\u7528\u4e8e\u6574\u578b\u5b57\u6bb5\uff01");
                    }
                    StringBuilder sqlBuilder = new StringBuilder("select max(");
                    sqlBuilder.append(field.getColumnName()).append(" ) as maxOrder from ").append(metaTable.getTableName()).append(" where ");
                    int pki = 0;
                    Object[] pkValues = new Object[pkCount - 1];
                    for (MetaColumn col : metaTable.getColumns()) {
                        if (!col.isPrimaryKey() || StringUtils.equals((CharSequence)col.getPropertyName(), (CharSequence)field.getPropertyName())) continue;
                        if (pki > 0) {
                            sqlBuilder.append(" and ");
                        }
                        sqlBuilder.append(col.getColumnName()).append(" = ?");
                        pkValues[pki] = object.get(col.getPropertyName());
                        ++pki;
                    }
                    Long pkSubOrder = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.fetchScalarObject((List)sqlDialect.findObjectsBySql(sqlBuilder.toString(), pkValues)));
                    object.put(field.getPropertyName(), pkSubOrder == null ? pkOrder : pkSubOrder + pkOrder);
                    break;
                }
            }
        }
    }

    private SourceInfo fetchDatabaseInfo(String databaseCode) {
        return this.sourceInfoDao.getDatabaseInfoById(databaseCode);
    }

    private Map<String, Object> innerGetObjectById(Connection conn, MetaTable tableInfo, Map<String, Object> pk) throws IOException, SQLException {
        JSONObject dbObject;
        GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
        if (pk.size() == 0) {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        if (dao.checkHasAllPkColumns(pk)) {
            dbObject = dao.getObjectById(pk);
        } else if (pk.containsKey("flowInstId")) {
            dbObject = dao.getObjectByProperties(pk);
        } else {
            throw new ObjectException("\u8868\u6216\u8005\u89c6\u56fe " + tableInfo.getTableName() + " \u7f3a\u5c11\u5bf9\u5e94\u4e3b\u952e:" + JSON.toJSONString(pk));
        }
        return DictionaryMapUtils.mapJsonObject((Map)dbObject, this.fetchDictionaryMapColumns(tableInfo));
    }

    private Map<String, Object> innerGetObjectPartFieldsById(Connection conn, MetaTable tableInfo, Map<String, Object> pk, String[] fields) throws IOException, SQLException {
        String filter;
        if (pk.size() == 0) {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        HashSet<String> fieldSet = this.collectPartFields(tableInfo, fields);
        Pair q = GeneralJsonObjectDao.buildPartFieldSqlWithFields((TableInfo)tableInfo, fieldSet, null, (boolean)false);
        if (GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)tableInfo, pk)) {
            filter = GeneralJsonObjectDao.buildFilterSqlByPk((TableInfo)tableInfo, null);
        } else if (pk.containsKey("flowInstId")) {
            filter = GeneralJsonObjectDao.buildFilterSql((TableInfo)tableInfo, null, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"flowInstId", pk.get("flowInstId"), "nodeInstId", pk.get("nodeInstId")}));
        } else {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        String querySql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName() + " where " + filter;
        JSONArray objs = GeneralJsonObjectDao.findObjectsByNamedSql((Connection)conn, (String)querySql, pk, (TableField[])((TableField[])q.getRight()));
        if (objs != null && objs.size() == 1) {
            return (JSONObject)objs.get(0);
        }
        return null;
    }

    @Override
    public MetaTable fetchTableInfo(String tableId) {
        return this.metaDataCache.getTableInfo(tableId);
    }

    @Override
    public Map<String, Object> getObjectById(String tableId, Map<String, Object> pk) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            return this.innerGetObjectById(conn, tableInfo, pk);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    private void fetchObjectParent(Connection conn, Map<String, Object> mainObj, MetaRelation md) throws SQLException, IOException {
        MetaTable parentTableInfo = this.metaDataCache.getTableInfo(md.getParentTableId());
        Map ref = md.fetchParentPk(mainObj);
        if (ref != null && GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)parentTableInfo, (Map)ref)) {
            JSONObject ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)parentTableInfo).getObjectById((Object)ref);
            mainObj.put(md.getRelationName(), DictionaryMapUtils.mapJsonObject((Map)ja, this.fetchDictionaryMapColumns(parentTableInfo)));
        }
    }

    private void fetchObjectParents(Connection conn, Map<String, Object> mainObj, MetaTable tableInfo) throws SQLException, IOException {
        List mds = tableInfo.getParents();
        if (mds != null) {
            for (MetaRelation md : mds) {
                if (md.getRelationDetails() == null) continue;
                this.fetchObjectParent(conn, mainObj, md);
            }
        }
    }

    private void fetchObjectRefrence(Connection conn, Map<String, Object> mainObj, MetaRelation md) throws SQLException, IOException {
        MetaTable subTableInfo = this.metaDataCache.getTableInfoWithRelations(md.getChildTableId());
        Map ref = md.fetchChildFk(mainObj);
        if (ref != null) {
            JSONArray ja = DictionaryMapUtils.mapJsonArray((JSONArray)GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)subTableInfo).listObjectsByProperties(ref), this.fetchDictionaryMapColumns(subTableInfo));
            mainObj.put(md.getRelationName(), ja);
        }
    }

    private void fetchObjectRefrences(Connection conn, Map<String, Object> mainObj, MetaTable tableInfo, int withChildrenDeep) throws SQLException, IOException {
        List mds = tableInfo.getMdRelations();
        if (mds != null) {
            for (MetaRelation md : mds) {
                MetaTable subTableInfo = this.metaDataCache.getTableInfoWithRelations(md.getChildTableId());
                Map ref = md.fetchChildFk(mainObj);
                if (ref == null) continue;
                JSONArray ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)subTableInfo).listObjectsByProperties(ref);
                ja = DictionaryMapUtils.mapJsonArray((JSONArray)ja, this.fetchDictionaryMapColumns(subTableInfo));
                if (withChildrenDeep > 1 && ja != null) {
                    for (Object subObject : ja) {
                        if (!(subObject instanceof Map)) continue;
                        this.fetchObjectRefrences(conn, (Map)subObject, subTableInfo, withChildrenDeep - 1);
                    }
                }
                mainObj.put(md.getRelationName(), ja);
            }
        }
    }

    @Override
    public Map<String, Object> getObjectWithChildren(String tableId, Map<String, Object> pk, String[] fields, String[] parents, String[] children) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoAll(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            Map<String, Object> mainObj = fields != null && fields.length > 0 ? this.innerGetObjectPartFieldsById(conn, tableInfo, pk, fields) : this.innerGetObjectById(conn, tableInfo, pk);
            mainObj = DictionaryMapUtils.mapJsonObject(mainObj, this.fetchDictionaryMapColumns(tableInfo));
            return this.fetchObjectParentAndChildren(tableInfo, mainObj, parents, children);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> fetchObjectParentAndChildren(MetaTable tableInfo, Map<String, Object> mainObj, String[] parents, String[] children) {
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            List mds;
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            if (parents != null && parents.length > 0 && (mds = tableInfo.getParents()) != null) {
                for (MetaRelation md : mds) {
                    if (!StringUtils.equalsAny((CharSequence)md.getReferenceName(), (CharSequence[])parents) || md.getRelationDetails() == null) continue;
                    this.fetchObjectParent(conn, mainObj, md);
                }
            }
            if ((mds = tableInfo.getMdRelations()) != null) {
                for (MetaRelation md : mds) {
                    if (!StringUtils.equalsAny((CharSequence)md.getReferenceName(), (CharSequence[])children) || md.getRelationDetails() == null) continue;
                    this.fetchObjectRefrence(conn, mainObj, md);
                }
            }
            return mainObj;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(mainObj, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getObjectWithChildren(String tableId, Map<String, Object> pk, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoAll(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            Map mainObj = this.innerGetObjectById(conn, tableInfo, pk);
            mainObj = DictionaryMapUtils.mapJsonObject(mainObj, this.fetchDictionaryMapColumns(tableInfo));
            if (withChildrenDeep > 0 && mainObj != null) {
                this.fetchObjectRefrences(conn, mainObj, tableInfo, withChildrenDeep);
            }
            if (mainObj != null) {
                this.fetchObjectParents(conn, mainObj, tableInfo);
            }
            return mainObj;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> makeNewObject(String tableId, Map<String, Object> extParams) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithParents(tableId);
        JSONObject objectMap = new JSONObject();
        if (extParams != null && !extParams.isEmpty()) {
            for (MetaColumn col : tableInfo.getColumns()) {
                Object colValue = extParams.get(col.getPropertyName());
                if (colValue == null) continue;
                objectMap.put((Object)col.getPropertyName(), colValue);
            }
        }
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            MetaObjectServiceImpl.makeObjectValueByGenerator((Map<String, Object>)objectMap, extParams, tableInfo, (JsonObjectDao)dao, 1L, true, true);
            this.fetchObjectParents(conn, (Map<String, Object>)objectMap, tableInfo);
            return objectMap;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException((Object)objectMap, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> makeNewObject(String tableId) {
        return this.makeNewObject(tableId, null);
    }

    private void checkFieldRule(MetaTable tableInfo, Map<String, Object> object) {
        List columns = tableInfo.getColumns();
        List checkFieldList = columns.stream().filter(metaColumn -> StringUtils.isNotBlank((CharSequence)metaColumn.getCheckRuleId())).collect(Collectors.toList());
        DataCheckResult result = DataCheckResult.create();
        for (MetaColumn metaColumn2 : checkFieldList) {
            String columnName = metaColumn2.getColumnName();
            DataCheckRule dataCheckRule = this.dataCheckRuleDao.getObjectById((Object)metaColumn2.getCheckRuleId());
            Map checkParam = CollectionsOpt.objectToMap((Object)metaColumn2.getCheckRuleParams());
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("checkValue", columnName);
            checkParam.forEach((key, value) -> {
                Map checkRouleInfo = CollectionsOpt.objectToMap((Object)value);
                String checkValue = StringBaseOpt.castObjectToString(checkRouleInfo.get("value"));
                if (StringUtils.isNotBlank((CharSequence)checkValue)) {
                    param.put((String)key, checkValue);
                }
            });
            result.checkData(object, dataCheckRule, param);
        }
        if (!result.getResult().booleanValue()) {
            throw new ObjectException(StringBaseOpt.castObjectToString(result.getErrorMsgs()));
        }
    }

    @Override
    public int updateObject(String tableId, Map<String, Object> object) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        this.checkFieldRule(tableInfo, object);
        MetaObjectServiceImpl.prepareObjectForSave(object, tableInfo);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            return GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).updateObject(object);
        }
        catch (SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectFields(String tableId, Collection<String> fields, Map<String, Object> object) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        this.checkFieldRule(tableInfo, object);
        MetaObjectServiceImpl.prepareObjectForSave(object, tableInfo);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            return dao.updateObjectsByProperties(fields, object, dao.makePkFieldMap(object));
        }
        catch (SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
    }

    @Override
    public int deleteObjectsByProperties(String tableId, Map<String, Object> filterProperties) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            return GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).deleteObjectsByProperties(filterProperties);
        }
        catch (SQLException e) {
            throw new ObjectException(filterProperties, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectsByProperties(String tableId, Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> filterProperties) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        this.checkFieldRule(tableInfo, fieldValues);
        MetaObjectServiceImpl.prepareObjectForSave(fieldValues, tableInfo);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            return GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).updateObjectsByProperties(fields, fieldValues, filterProperties);
        }
        catch (SQLException e) {
            throw new ObjectException(fieldValues, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectsByProperties(String tableId, Map<String, Object> fieldValues, Map<String, Object> filterProperties) {
        return this.updateObjectsByProperties(tableId, fieldValues.keySet(), fieldValues, filterProperties);
    }

    @Override
    public void deleteObject(String tableId, Map<String, Object> pk) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).deleteObjectById(pk);
        }
        catch (SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public int saveObject(String tableId, Map<String, Object> object) {
        return this.innerSaveObject(tableId, object, null, false, 0);
    }

    @Override
    public int saveObject(String tableId, Map<String, Object> object, Map<String, Object> extParams) {
        return this.innerSaveObject(tableId, object, extParams, false, 0);
    }

    public int replaceObjectsAsTabulation(GeneralJsonObjectDao dao, MetaTable relTableInfo, List<Map<String, Object>> newObjects, Map<String, Object> extParams, Map<String, Object> properties, int withChildrenDeep) throws SQLException, IOException {
        JSONArray dbObjects = dao.listObjectsByProperties(properties);
        Triple comRes = CollectionsOpt.compareTwoList((List)dbObjects, newObjects, (Comparator)new GeneralJsonObjectDao.JSONObjectComparator((TableInfo)relTableInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Map obj : (List)comRes.getLeft()) {
                resN += this.innerSaveObject(relTableInfo.getTableId(), obj, extParams, false, withChildrenDeep);
            }
        }
        if (comRes.getRight() != null) {
            for (Map obj : (List)comRes.getRight()) {
                ++resN;
                this.deleteObjectWithChildren(relTableInfo.getTableId(), obj, withChildrenDeep);
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                if (withChildrenDeep <= 0) {
                    if (!GeneralJsonObjectDao.checkNeedUpdate((Map)((Map)pobj.getLeft()), (Map)((Map)pobj.getRight()))) continue;
                }
                resN += this.innerSaveObject(relTableInfo.getTableId(), (Map)pobj.getRight(), extParams, true, withChildrenDeep);
            }
        }
        return resN;
    }

    private int innerSaveObject(String tableId, Map<String, Object> mainObj, Map<String, Object> extParams, boolean isUpdate, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        this.checkFieldRule(tableInfo, mainObj);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            GeneralJsonObjectDao dao;
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            if (isUpdate) {
                dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
                MetaObjectServiceImpl.makeObjectValueByGenerator(mainObj, extParams, tableInfo, (JsonObjectDao)dao, 1L, false, false);
                MetaObjectServiceImpl.prepareObjectForSave(mainObj, tableInfo);
                dao.updateObject(mainObj);
            } else {
                dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
                MetaObjectServiceImpl.makeObjectValueByGenerator(mainObj, extParams, tableInfo, (JsonObjectDao)dao, 1L, false, true);
                MetaObjectServiceImpl.prepareObjectForSave(mainObj, tableInfo);
                if (tableInfo.hasGeneratedKeys()) {
                    MetaColumn column;
                    Map ids = dao.saveNewObjectAndFetchGeneratedKeys(mainObj);
                    if (ids != null && !ids.isEmpty() && (column = tableInfo.fetchGeneratedKey()) != null) {
                        mainObj.put(column.getPropertyName(), ids.values().iterator().next());
                    }
                } else {
                    dao.saveNewObject(mainObj);
                }
            }
            if (withChildrenDeep < 1) {
                return 1;
            }
            List mds = tableInfo.getMdRelations();
            if (mds != null) {
                for (MetaRelation md : mds) {
                    MetaTable relTableInfo;
                    Object subObjects = mainObj.get(md.getRelationName());
                    if (subObjects == null || !"T".equals((relTableInfo = this.metaDataCache.getTableInfo(md.getChildTableId())).getTableType())) continue;
                    ArrayList<Map<String, Object>> subTable = null;
                    Map ref = md.fetchChildFk(mainObj);
                    if (subObjects instanceof List) {
                        subTable = (ArrayList<Map<String, Object>>)subObjects;
                        for (Map map : subTable) {
                            map.putAll(ref);
                        }
                    } else if (subObjects instanceof Map) {
                        subTable = new ArrayList<Map<String, Object>>(2);
                        ((Map)subObjects).putAll(ref);
                        subTable.add((Map)subObjects);
                    }
                    GeneralJsonObjectDao dao2 = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo);
                    this.replaceObjectsAsTabulation(dao2, relTableInfo, subTable, extParams, ref, withChildrenDeep - 1);
                }
            }
            return 1;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(mainObj, 620, (Throwable)e);
        }
    }

    @Override
    public int saveObjectWithChildren(String tableId, Map<String, Object> object, Map<String, Object> extParams, int withChildrenDeep) {
        return this.innerSaveObject(tableId, object, extParams, false, withChildrenDeep);
    }

    @Override
    public int saveObjectWithChildren(String tableId, Map<String, Object> object, int withChildrenDeep) {
        return this.innerSaveObject(tableId, object, null, false, withChildrenDeep);
    }

    @Override
    public int updateObjectWithChildren(String tableId, Map<String, Object> object, Map<String, Object> extParams, int withChildrenDeep) {
        return this.innerSaveObject(tableId, object, extParams, true, withChildrenDeep);
    }

    @Override
    public int updateObjectWithChildrenCheckVersion(String tableId, Map<String, Object> object, Map<String, Object> extParams, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        List fields = tableInfo.extraVersionFields();
        if (fields == null || fields.size() == 0) {
            throw new ObjectException(object, 612, "\u5143\u6570\u636e\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u66f4\u65b0\u7248\u672c\u6807\u8bc6\u4fe1\u606f\uff1a" + tableId);
        }
        try {
            SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            JSONObject mainObj = dao.getObjectById(object);
            for (String field : fields) {
                if (GeneralAlgorithm.equals(mainObj.get(field), (Object)object.get(field))) continue;
                throw new ObjectException(object, 611, "\u8ddf\u65b0\u524d\u7248\u672c\u6821\u9a8c\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u88ab\u5176\u4ed6\u4e1a\u52a1\u66f4\u6539\uff1a" + tableId);
            }
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
        return this.innerSaveObject(tableId, object, null, true, withChildrenDeep);
    }

    @Override
    public void deleteObjectWithChildren(String tableId, Map<String, Object> pk, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            List mds;
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            JSONObject mainObj = dao.getObjectById(pk);
            if (null == mainObj || mainObj.size() == 0) {
                return;
            }
            if (withChildrenDeep > 0 && (mds = tableInfo.getMdRelations()) != null) {
                for (MetaRelation md : mds) {
                    MetaTable relTableInfo = this.metaDataCache.getTableInfo(md.getChildTableId());
                    if (!"T".equals(relTableInfo.getTableType())) continue;
                    List mdChilds = relTableInfo.getMdRelations();
                    if (mdChilds != null && withChildrenDeep > 1) {
                        JSONArray children = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo).listObjectsByProperties(md.fetchChildFk((Map)mainObj));
                        if (children == null || children.size() <= 0) continue;
                        for (Object obj : children) {
                            this.deleteObjectWithChildren(relTableInfo.getTableId(), (Map)obj, withChildrenDeep - 1);
                        }
                        continue;
                    }
                    GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo).deleteObjectsByProperties(md.fetchChildFk((Map)mainObj));
                }
            }
            dao.deleteObjectById(pk);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    private void innerSoftDeleteObject(Connection conn, MetaTable tableInfo, Map<String, Object> pk, int withChildrenDeep) throws SQLException, IOException {
        List mds;
        GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
        JSONObject mainObj = dao.getObjectById(pk);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getDeleteTagField())) {
            Map deleteTag = tableInfo.extraDeleteTag();
            mainObj.putAll(deleteTag);
            dao.updateObject(deleteTag.keySet(), (Map)mainObj);
        }
        if (withChildrenDeep > 0 && (mds = tableInfo.getMdRelations()) != null) {
            for (MetaRelation md : mds) {
                MetaTable relTableInfo = this.metaDataCache.getTableInfo(md.getChildTableId());
                if (!"T".equals(relTableInfo.getTableType())) continue;
                List mdChilds = relTableInfo.getMdRelations();
                if (mdChilds != null && withChildrenDeep > 1) {
                    JSONArray children = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo).listObjectsByProperties(md.fetchChildFk((Map)mainObj));
                    if (children == null || children.size() <= 0) continue;
                    for (Object obj : children) {
                        this.innerSoftDeleteObject(conn, relTableInfo, (Map)obj, withChildrenDeep - 1);
                    }
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)relTableInfo.getDeleteTagField())) continue;
                Map deleteTag = relTableInfo.extraDeleteTag();
                GeneralJsonObjectDao subTableDao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo);
                subTableDao.updateObjectsByProperties(deleteTag.keySet(), deleteTag, md.fetchChildFk((Map)mainObj));
            }
        }
    }

    @Override
    public void softDeleteObjectWithChildren(String tableId, Map<String, Object> pk, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        if (StringUtils.isBlank((CharSequence)tableInfo.getDeleteTagField())) {
            throw new ObjectException(pk, 612, "\u5143\u6570\u636e\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u903b\u8f91\u5220\u9664\u6807\u8bb0\u4fe1\u606f\uff1a" + tableId);
        }
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            this.innerSoftDeleteObject(conn, tableInfo, pk, withChildrenDeep);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public int mergeObjectWithChildren(String tableId, Map<String, Object> object, Map<String, Object> extParams, int withChildrenDeep) {
        Map<String, Object> dbObject;
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        Map dbObjectPk = tableInfo.fetchObjectPk(object);
        Map<String, Object> map = dbObject = dbObjectPk == null ? null : this.getObjectById(tableId, dbObjectPk);
        if (dbObject == null) {
            return this.saveObjectWithChildren(tableId, object, extParams, withChildrenDeep);
        }
        return this.updateObjectWithChildren(tableId, object, extParams, withChildrenDeep);
    }

    @Override
    public JSONArray listObjectsByProperties(String tableId, Map<String, Object> filter) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            JSONArray ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).listObjectsByProperties(filter);
            return DictionaryMapUtils.mapJsonArray((JSONArray)ja, this.fetchDictionaryMapColumns(tableInfo));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(filter, 620, (Throwable)e);
        }
    }

    private HashSet<String> collectPartFields(MetaTable tableInfo, String[] fields) {
        HashSet<String> fieldSet = new HashSet<String>((fields.length + 5) * 3 / 2);
        for (TableField pkField : tableInfo.getPkFields()) {
            fieldSet.add(pkField.getPropertyName());
        }
        if (!"0".equals(tableInfo.getWorkFlowOptType())) {
            fieldSet.add("flowInstId");
            fieldSet.add("nodeInstId");
        }
        Collections.addAll(fieldSet, fields);
        return fieldSet;
    }

    private Map<String, Object> mapPoToDto(Map<String, Object> po) {
        Object obj = po.get("objectJson");
        if (obj instanceof Map) {
            Map dto = (Map)obj;
            for (Map.Entry<String, Object> ent : po.entrySet()) {
                if ("objectJson".equals(ent.getKey()) || ent.getValue() == null) continue;
                dto.put(ent.getKey(), ent.getValue());
            }
            return dto;
        }
        return po;
    }

    private JSONArray mapListPoToDto(JSONArray ja) {
        if (ja == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(ja.size());
        for (Object json : ja) {
            if (json instanceof Map) {
                jsonArray.add(this.mapPoToDto((Map)json));
                continue;
            }
            jsonArray.add(json);
        }
        return jsonArray;
    }

    private Map<String, Object> mapDtoToPo(Map<String, Object> dto) {
        HashMap<String, Object> po = new HashMap<String, Object>(dto);
        po.remove("objectJson");
        String jsonString = JSON.toJSONString(po);
        po.put("objectJson", jsonString);
        return po;
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, String extFilter, Map<String, Object> params, String[] fields, PageDesc pageDesc) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        if (tableInfo == null) {
            throw new ObjectException("\u65e0\u6b64\u5143\u6570\u636e\u8868" + tableId);
        }
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            String orderBy;
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            HashSet<String> fieldSet = null;
            if (fields != null && fields.length > 0) {
                fieldSet = this.collectPartFields(tableInfo, fields);
            }
            Pair q = fieldSet == null ? GeneralJsonObjectDao.buildFieldSqlWithFields((TableInfo)tableInfo, null, (boolean)true) : GeneralJsonObjectDao.buildPartFieldSqlWithFields((TableInfo)tableInfo, fieldSet, null, (boolean)false);
            String filter = GeneralJsonObjectDao.buildFilterSql((TableInfo)tableInfo, null, params);
            if (StringUtils.isNotBlank((CharSequence)extFilter)) {
                filter = StringUtils.isNotBlank((CharSequence)filter) ? extFilter + " and " + filter : extFilter;
            }
            String sql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                sql = sql + " where " + filter;
            }
            if (StringUtils.isNotBlank((CharSequence)(orderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)sql, params)))) {
                sql = sql + " order by " + QueryUtils.cleanSqlStatement((String)orderBy);
            }
            String querySql = pageDesc.getPageSize() < 0 ? sql : QueryUtils.buildLimitQuerySQL((String)sql, (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize(), (boolean)false, (DBType)sourceInfo.getDBType());
            JSONArray objs = GeneralJsonObjectDao.findObjectsByNamedSql((Connection)conn, (String)querySql, params, (TableField[])((TableField[])q.getRight()));
            String sGetCountSql = "select count(1) as totalRows from " + tableInfo.getTableName();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                sGetCountSql = sGetCountSql + " where " + filter;
            }
            Object obj = DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sGetCountSql, params);
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)obj));
            if ("C".equals(tableInfo.getTableType())) {
                objs = this.mapListPoToDto(objs);
            }
            return DictionaryMapUtils.mapJsonArray((JSONArray)objs, this.fetchDictionaryMapColumns(tableInfo));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, Map<String, Object> params, String[] fields, PageDesc pageDesc) {
        return this.pageQueryObjects(tableId, null, params, fields, pageDesc);
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, Map<String, Object> params, PageDesc pageDesc) {
        return this.pageQueryObjects(tableId, null, params, null, pageDesc);
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, String namedSql, Map<String, Object> params, PageDesc pageDesc) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        SourceInfo sourceInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        String orderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)namedSql, params);
        String querySql = StringUtils.isBlank((CharSequence)orderBy) ? namedSql : QueryUtils.removeOrderBy((String)namedSql) + " order by " + QueryUtils.cleanSqlStatement((String)orderBy);
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            JSONArray objs = dao.findObjectsByNamedSqlAsJSON(querySql, params, null, pageDesc.getPageNo(), pageDesc.getPageSize());
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.queryTotalRows((Connection)conn, (String)querySql, params)));
            return DictionaryMapUtils.mapJsonArray((JSONArray)objs, this.fetchDictionaryMapColumns(tableInfo));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray paramDriverPageQueryObjects(String tableId, String paramDriverSql, Map<String, Object> params, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)paramDriverSql, params);
        return this.pageQueryObjects(tableId, qap.getQuery(), qap.getParams(), pageDesc);
    }

    private List<DictionaryMapColumn> fetchDictionaryMapColumns(MetaTable tableInfo) {
        if (tableInfo.getMdColumns() == null || tableInfo.getMdColumns().size() == 0) {
            return null;
        }
        ArrayList<DictionaryMapColumn> dictionaryMapColumns = new ArrayList<DictionaryMapColumn>(4);
        for (MetaColumn mc : tableInfo.getMdColumns()) {
            String catalogCode;
            if ("1".equals(mc.getReferenceType())) {
                MetaObjectServiceImpl.setDictionaryColumns(dictionaryMapColumns, mc, false);
                continue;
            }
            if ("2".equals(mc.getReferenceType())) {
                Object jsonObject;
                String jsonStr = mc.getReferenceData().trim();
                catalogCode = Md5Encoder.encodeBase64((String)jsonStr, (boolean)true);
                boolean hasDictoinary = CodeRepositoryUtil.hasExtendedDictionary((String)catalogCode);
                if (!hasDictoinary && (jsonObject = JSON.parse((String)jsonStr)) instanceof Map) {
                    CodeRepositoryUtil.registeExtendedCodeRepo((String)catalogCode, (Map)CollectionsOpt.objectMapToStringMap((Map)((Map)jsonObject)));
                    hasDictoinary = true;
                }
                if (!hasDictoinary) continue;
                dictionaryMapColumns.add(new DictionaryMapColumn(mc.getPropertyName(), mc.getPropertyName() + "Desc", catalogCode));
                continue;
            }
            if ("3".equals(mc.getReferenceType())) {
                String sqlStr = mc.getReferenceData().trim();
                catalogCode = Md5Encoder.encodeBase64((String)(tableInfo.getDatabaseCode() + sqlStr), (boolean)true);
                if (!CodeRepositoryUtil.hasExtendedDictionary((String)catalogCode)) {
                    CodeRepositoryUtil.registeExtendedCodeRepo((String)catalogCode, (CachedObject)new CachedObject((Supplier)new SqlDictionaryMapSupplier(this.sourceInfoDao.getDatabaseInfoById(tableInfo.getDatabaseCode()), sqlStr), 180L));
                }
                DictionaryMapColumn dictionaryMapColumn = new DictionaryMapColumn(mc.getPropertyName(), mc.getPropertyName() + "Desc", catalogCode);
                dictionaryMapColumn.setExpression(true);
                dictionaryMapColumns.add(dictionaryMapColumn);
                continue;
            }
            if (!"4".equals(mc.getReferenceType())) continue;
            MetaObjectServiceImpl.setDictionaryColumns(dictionaryMapColumns, mc, true);
        }
        return dictionaryMapColumns;
    }

    @Override
    public Map<String, String> fetchColumnRefData(String tableId, String columnCode, String topUnit, String lang) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        MetaColumn mc = tableInfo.findFieldByColumn(columnCode);
        if ("1".equals(mc.getReferenceType())) {
            return CodeRepositoryUtil.getLabelValueMap((String)mc.getReferenceData(), (String)topUnit, (String)lang);
        }
        if ("2".equals(mc.getReferenceType())) {
            String jsonStr = mc.getReferenceData().trim();
            Object jsonObject = JSON.parse((String)jsonStr);
            if (jsonObject instanceof JSONObject) {
                return CollectionsOpt.objectMapToStringMap((Map)((Map)jsonObject));
            }
            return null;
        }
        if ("3".equals(mc.getReferenceType())) {
            String sqlStr = mc.getReferenceData().trim();
            SqlDictionaryMapSupplier mapSupplier = new SqlDictionaryMapSupplier(this.sourceInfoDao.getDatabaseInfoById(tableInfo.getDatabaseCode()), sqlStr);
            return mapSupplier.get();
        }
        if ("4".equals(mc.getReferenceType())) {
            Object jsonObject = JSON.parse((String)mc.getReferenceData());
            HashMap<String, String> datamap = new HashMap<String, String>(100);
            if (jsonObject instanceof JSONObject) {
                for (Map.Entry ent : ((JSONObject)jsonObject).entrySet()) {
                    Map dictMap = CodeRepositoryUtil.getLabelValueMap((String)StringBaseOpt.castObjectToString(ent.getValue()), (String)topUnit, (String)lang);
                    if (dictMap == null) continue;
                    datamap.putAll(dictMap);
                }
            }
            return datamap;
        }
        return null;
    }

    private static void setDictionaryColumns(List<DictionaryMapColumn> dictionaryMapColumns, MetaColumn mc, boolean isExpression) {
        if (mc.getReferenceData().startsWith("{")) {
            Object jsonObject = JSON.parse((String)mc.getReferenceData());
            if (jsonObject instanceof JSONObject) {
                for (Map.Entry ent : ((JSONObject)jsonObject).entrySet()) {
                    DictionaryMapColumn dictionaryMapColumn = new DictionaryMapColumn(mc.getPropertyName(), (String)ent.getKey(), StringBaseOpt.castObjectToString(ent.getValue()));
                    dictionaryMapColumn.setExpression(isExpression);
                    dictionaryMapColumns.add(dictionaryMapColumn);
                }
            }
        } else {
            DictionaryMapColumn dictionaryMapColumn = new DictionaryMapColumn(mc.getPropertyName(), mc.getPropertyName() + "Desc", mc.getReferenceData());
            dictionaryMapColumn.setExpression(isExpression);
            dictionaryMapColumns.add(dictionaryMapColumn);
        }
    }

    @Override
    public JSONArray queryDatas(String databaseCode, String namedSql, Map<String, Object> params) {
        SourceInfo sourceInfo = this.fetchDatabaseInfo(databaseCode);
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)namedSql, params);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray pageQueryDatas(String databaseCode, String namedSql, Map<String, Object> params, PageDesc pageDesc) {
        SourceInfo sourceInfo = this.fetchDatabaseInfo(databaseCode);
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
            String sGetCountSql = QueryUtils.buildGetCountSQL((String)namedSql);
            Object obj = DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sGetCountSql, params);
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)obj));
            return DatabaseAccess.findObjectsByNamedSqlAsJSON((Connection)conn, (String)namedSql, params, null, (int)pageDesc.getPageNo(), (int)pageDesc.getPageSize());
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }
}

