/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBConnectPools.class);
    private static final ConcurrentHashMap<ISourceInfo, HikariDataSource> DATABASE_SOURCE_POOLS = new ConcurrentHashMap();

    private AbstractDBConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static HikariDataSource createDataSource(ISourceInfo dsDesc) {
        HikariDataSource ds = new HikariDataSource();
        DBType dbType = DBType.mapDBType((String)dsDesc.getDatabaseUrl());
        ds.setDriverClassName(DBType.getDbDriver((DBType)dbType));
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getClearPassword());
        ds.setJdbcUrl(dsDesc.getDatabaseUrl());
        ds.setMaximumPoolSize(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("maxActive"), (Integer)50).intValue());
        ds.setMaxLifetime((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("maxLifetime"), (Integer)180000).intValue());
        ds.setIdleTimeout((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("idleTimeout"), (Integer)6000).intValue());
        ds.setConnectionTimeout((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("connectionTimeout"), (Integer)5000).intValue());
        ds.setMinimumIdle(NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("minIdle"), (Integer)5).intValue());
        String validationQuery = StringBaseOpt.castObjectToString((Object)dsDesc.getExtProp("validationQuery"));
        if (StringUtils.isBlank((CharSequence)validationQuery)) {
            validationQuery = DBType.getDBValidationQuery((DBType)dbType);
        }
        ds.setValidationTimeout((long)NumberBaseOpt.castObjectToInteger((Object)dsDesc.getExtProp("validationTimeout"), (Integer)5000).intValue());
        boolean testWhileIdle = BooleanBaseOpt.castObjectToBoolean((Object)dsDesc.getExtProp("testWhileIdle"), (Boolean)true);
        if (testWhileIdle && StringUtils.isNotBlank((CharSequence)validationQuery)) {
            ds.setConnectionTestQuery(validationQuery);
        }
        return ds;
    }

    public static void refreshDataSource(ISourceInfo dsDesc) {
        HikariDataSource ds;
        HikariDataSource oldDs;
        if (DATABASE_SOURCE_POOLS.containsKey(dsDesc) && (oldDs = DATABASE_SOURCE_POOLS.put(dsDesc, ds = AbstractDBConnectPools.createDataSource(dsDesc))) != null) {
            oldDs.close();
        }
    }

    public static void delDataSource(ISourceInfo dsDesc) {
        if (DATABASE_SOURCE_POOLS.containsKey(dsDesc)) {
            HikariDataSource oldDs = DATABASE_SOURCE_POOLS.get(dsDesc);
            if (oldDs != null) {
                oldDs.close();
            }
            DATABASE_SOURCE_POOLS.remove(dsDesc);
        }
    }

    public static synchronized Connection getDbcpConnect(ISourceInfo dsDesc) throws SQLException {
        HikariDataSource ds = DATABASE_SOURCE_POOLS.get(dsDesc);
        if (ds == null) {
            ds = AbstractDBConnectPools.createDataSource(dsDesc);
            DATABASE_SOURCE_POOLS.put(dsDesc, ds);
        }
        Connection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void testConnect(SourceInfo sourceInfo) throws SQLException {
        HikariDataSource ds = AbstractDBConnectPools.createDataSource((ISourceInfo)sourceInfo);
        Connection conn = null;
        try {
            conn = ds.getConnection();
            conn.close();
            ds.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            ds.close();
        }
    }
}

