/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEsClientPools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEsClientPools.class);

    private AbstractEsClientPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static GenericObjectPool<RestHighLevelClient> fetchClientPool(ISourceInfo dsDesc, boolean createNew) {
        ESServerConfig config = new ESServerConfig();
        String[] hostAndIp = dsDesc.getDatabaseUrl().split(":");
        config.setServerHostIp(hostAndIp[0]);
        if (hostAndIp.length > 1) {
            config.setServerHostPort(hostAndIp[1]);
        } else {
            String port = StringBaseOpt.castObjectToString((Object)dsDesc.getExtProp("port"), (String)"9200");
            config.setServerHostPort(port);
        }
        config.setClusterName(StringBaseOpt.castObjectToString((Object)dsDesc.getExtProp("cluster")));
        config.setOsId(dsDesc.getOsId());
        config.setUsername(dsDesc.getUsername());
        config.setPassword(dsDesc.getClearPassword());
        config.setMinScore(NumberBaseOpt.castObjectToFloat((Object)dsDesc.getExtProp("minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return IndexerSearcherFactory.obtainclientPool((ESServerConfig)config, (boolean)createNew);
    }

    public static synchronized RestHighLevelClient fetchESClient(ISourceInfo dsDesc) throws Exception {
        GenericObjectPool<RestHighLevelClient> clientPool = AbstractEsClientPools.fetchClientPool(dsDesc, true);
        return (RestHighLevelClient)clientPool.borrowObject();
    }

    public static void returnClient(ISourceInfo dsDesc, RestHighLevelClient client) {
        GenericObjectPool<RestHighLevelClient> clientPool = AbstractEsClientPools.fetchClientPool(dsDesc, false);
        if (clientPool != null) {
            clientPool.returnObject((Object)client);
        }
    }
}

