/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.workday.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.workday.po.WorkDay;
import com.centit.support.workday.service.WorkDayManager;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/calendar"})
public class EnterpriseCalendarController
extends BaseController {
    @Resource
    private WorkDayManager workDayMag;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u6708\u4efd\u6240\u6709\u6807\u8bb0\u65e5\u671f\uff0c\u5305\u62ec\uff1a\u52a0\u73ed\u548c\u8c03\u4f11\u3002")
    @RequestMapping(value={"/{sCurDate}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public WorkDay getMarkDay(@PathVariable String sCurDate) {
        return this.workDayMag.getWorkDay(sCurDate);
    }

    @ApiOperation(value="\u4fdd\u5b58\u65e5\u671f\u6807\u8bb0\uff0c\u5982\u679c\u65e5\u671f\u6807\u8bb0\u4e3a\u20180\u2019\u8868\u793a\u8fd8\u539f\u9ed8\u8ba4\u503c\uff0c\u7cfb\u7edf\u4f1a\u5220\u9664\u5bf9\u5e94\u7684\u6807\u8bb0\u8bb0\u5f55\u3002")
    @WrapUpResponseBody
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void saveData(WorkDay workDay) {
        if (WorkDay.WORK_DAY_TYPE_IGNORE.equals(workDay.getDayType())) {
            this.workDayMag.deleteWorkDay(workDay.getWorkDay());
        } else {
            WorkDay dbWorkDay = this.workDayMag.getWorkDay(workDay.getWorkDay());
            if (dbWorkDay != null) {
                dbWorkDay.copyNotNullProperty(workDay);
                this.workDayMag.updateWorkDay(workDay);
            } else {
                this.workDayMag.saveWorkDay(workDay);
            }
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u65e5\u671f\u6807\u8bb0\uff0c\u5982\u679c\u65e5\u671f\u6807\u8bb0\u4e3a\u20180\u2019\u8868\u793a\u8fd8\u539f\u9ed8\u8ba4\u503c\uff0c\u7cfb\u7edf\u4f1a\u5220\u9664\u5bf9\u5e94\u7684\u6807\u8bb0\u8bb0\u5f55\u3002")
    @WrapUpResponseBody
    @RequestMapping(value={"/{sCurDate}"}, method={RequestMethod.DELETE})
    public void deleteWorkDay(@PathVariable String sCurDate) {
        this.workDayMag.deleteWorkDay(sCurDate);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u6708\u4efd\u6240\u6709\u6807\u8bb0\u65e5\u671f\uff0c\u5305\u62ec\uff1a\u52a0\u73ed\u548c\u8c03\u4f11\u3002")
    @RequestMapping(value={"/month/{sCurDate}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<WorkDay> findMarkDayByCurrMonth(@PathVariable String sCurDate) {
        Date curDate = DatetimeOpt.smartPraseDate((String)sCurDate);
        if (curDate == null) {
            curDate = DatetimeOpt.currentUtilDate();
        }
        Date startDate = DatetimeOpt.truncateToMonth((Date)curDate);
        Date endDate = DatetimeOpt.seekEndOfMonth((Date)curDate);
        return this.workDayMag.listWorkDays(DatetimeOpt.convertDateToString((Date)startDate), DatetimeOpt.convertDateToString((Date)endDate));
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u5b9a\u8303\u56f4\u5185\u6240\u6709\u6807\u8bb0\u65e5\u671f\uff0c\u5305\u62ec\uff1a\u52a0\u73ed\u548c\u8c03\u4f11\u3002")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<WorkDay> listMarkDay(HttpServletRequest request) {
        String startDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"startDate", "start", "beginDate", "begin"});
        String endDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"endDate", "end"});
        return this.workDayMag.listWorkDays(startDate, endDate);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u5b9a\u8303\u56f4\u5185\u6240\u6709\u5de5\u4f5c\u65e5\u3002")
    @RequestMapping(value={"/rangeWorkDays"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<WorkDay> rangeWorkDays(HttpServletRequest request) {
        String startDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"startDate", "start", "beginDate", "begin"});
        String endDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"endDate", "end"});
        return this.workDayMag.rangeWorkDays(startDate, endDate);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u5b9a\u8303\u56f4\u5185\u6240\u6709\u975e\u5de5\u4f5c\u65e5\u3002")
    @RequestMapping(value={"/rangeWorkDays"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<WorkDay> rangeHolidays(HttpServletRequest request) {
        String startDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"startDate", "start", "beginDate", "begin"});
        String endDate = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"endDate", "end"});
        return this.workDayMag.rangeHolidays(startDate, endDate);
    }
}

