/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import org.apache.commons.lang3.StringUtils;

public abstract class BooleanBaseOpt {
    public static final String ONE_CHAR_TRUE = "T";
    public static final String ONE_CHAR_FALSE = "F";
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";

    private BooleanBaseOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static Boolean castObjectToBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = StringBaseOpt.objectToString(obj);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)str, (CharSequence[])new CharSequence[]{"y", "yes", "t", STRING_TRUE, "on"})) {
            return true;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)str, (CharSequence[])new CharSequence[]{"n", "no", "f", STRING_FALSE, "off"})) {
            return false;
        }
        return null;
    }

    public static Boolean castObjectToBoolean(Object obj, Boolean defaultValue) {
        return GeneralAlgorithm.nvl(BooleanBaseOpt.castObjectToBoolean(obj), defaultValue);
    }

    public static boolean isBoolean(Object obj) {
        return BooleanBaseOpt.castObjectToBoolean(obj) != null;
    }
}

