/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedMap<K, T>
extends AbstractCachedObject<Map<K, T>> {
    private static Log logger = LogFactory.getLog(CachedMap.class);
    private ConcurrentMap<K, CachedIdentifiedObject> targetMap;
    private long freshPeriod;
    private Function<K, T> refresher;

    public CachedMap() {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(16);
        this.refresher = null;
        this.freshPeriod = 2592000L;
    }

    public CachedMap(Function<K, T> refresher, long freshPeriod, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(initialCapacity);
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedMap(Function<K, T> refresher, AbstractCachedObject<?> parentCache, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(initialCapacity);
        this.refresher = refresher;
        parentCache.addDeriveCache(this);
        this.freshPeriod = 2592000L;
    }

    public CachedMap(Function<K, T> refresher, long freshPeriod) {
        this(refresher, freshPeriod, 16);
    }

    public CachedMap(Function<K, T> refresher, AbstractCachedObject<?> parentCache) {
        this(refresher, parentCache, 16);
    }

    public void setRefresher(Function<K, T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshPeriod(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public void evictIdentifiedCache(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.evictCahce();
        }
    }

    @Override
    public void evictCahce() {
        this.targetMap.clear();
        super.evictCahce();
    }

    public AbstractCachedObject<T> getCachedObject(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject == null) {
            identifiedObject = new CachedIdentifiedObject();
            Object target = identifiedObject.getFreshTarget(key);
            if (target != null) {
                this.targetMap.put(key, identifiedObject);
            } else {
                identifiedObject = null;
            }
        }
        return identifiedObject;
    }

    public T getCachedValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getCachedTarget(key);
        }
        identifiedObject = new CachedIdentifiedObject();
        Object target = identifiedObject.getFreshTarget(key);
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    public T getFreshValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getFreshTarget(key);
        }
        identifiedObject = new CachedIdentifiedObject();
        Object target = identifiedObject.getFreshTarget(key);
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    public boolean isFreshData(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.evicted;
        }
        return false;
    }

    @Override
    public Map<K, T> getRawTarget() {
        if (this.targetMap == null) {
            return null;
        }
        HashMap rawTargetMap = new HashMap(this.targetMap.size() + 1);
        for (Map.Entry ent : this.targetMap.entrySet()) {
            rawTargetMap.put(ent.getKey(), ((CachedIdentifiedObject)ent.getValue()).getRawTarget());
        }
        return rawTargetMap;
    }

    public void setFreshData(K key, T freshData) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.setFreshData(freshData);
        } else {
            this.targetMap.put(key, new CachedIdentifiedObject(freshData));
        }
    }

    class CachedIdentifiedObject
    extends AbstractCachedObject<T> {
        CachedIdentifiedObject(T target) {
            this.target = CollectionsOpt.unmodifiableObject(target);
            this.evicted = false;
            this.refreshTime = DatetimeOpt.currentUtilDate();
        }

        CachedIdentifiedObject() {
            this.target = null;
            this.evicted = true;
        }

        synchronized void refreshData(K key) {
            this.evictDerivativeCahce();
            Object tempTarget = null;
            try {
                tempTarget = CachedMap.this.refresher.apply(key);
            }
            catch (RuntimeException re) {
                logger.error((Object)re.getLocalizedMessage());
            }
            this.setRefreshDataAndState(tempTarget, CachedMap.this.freshPeriod, true);
        }

        T getCachedTarget(K key) {
            if (this.target == null || this.isTargetOutOfDate(CachedMap.this.freshPeriod)) {
                this.refreshData(key);
            }
            return this.target;
        }

        T getFreshTarget(K key) {
            this.refreshData(key);
            return this.target;
        }

        @Override
        public T getRawTarget() {
            return this.target;
        }

        void setFreshData(T freshData) {
            this.target = CollectionsOpt.unmodifiableObject(freshData);
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        }
    }
}

