/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedObject<T>
extends AbstractCachedObject<T> {
    private static Log logger = LogFactory.getLog(CachedObject.class);
    private Supplier<T> refresher;
    protected long freshPeriod;

    public CachedObject() {
    }

    public CachedObject(Supplier<T> refresher) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        this.freshPeriod = 2592000L;
    }

    public CachedObject(Supplier<T> refresher, long freshPeriod) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?> parentCache) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        parentCache.addDeriveCache(this);
        this.freshPeriod = 2592000L;
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?>[] parentCaches) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        for (AbstractCachedObject<?> parentCache : parentCaches) {
            parentCache.addDeriveCache(this);
        }
        this.freshPeriod = 2592000L;
    }

    public void setFreshPeriod(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    protected synchronized void refreshData() {
        this.evictDerivativeCahce();
        Object tempTarget = null;
        try {
            tempTarget = this.refresher.get();
        }
        catch (RuntimeException re) {
            logger.error((Object)re.getMessage(), (Throwable)re);
        }
        this.setRefreshDataAndState(tempTarget, this.freshPeriod, true);
    }

    public T getCachedTarget() {
        if (this.target == null || this.isTargetOutOfDate(this.freshPeriod)) {
            this.refreshData();
        }
        return (T)this.target;
    }

    public T getFreshTarget() {
        this.refreshData();
        return (T)this.target;
    }

    @Override
    public T getRawTarget() {
        return (T)this.target;
    }

    public void setRefresher(Supplier<T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshData(T freshData) {
        this.target = CollectionsOpt.unmodifiableObject(freshData);
        this.refreshTime = DatetimeOpt.currentUtilDate();
        this.evicted = false;
    }
}

