/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import com.centit.support.security.Md5Encoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public abstract class ImageOpt {
    private ImageOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static void createThumbnail(String filename, int thumbWidth, int thumbHeight, int quality, String outFilename) throws InterruptedException, FileNotFoundException, IOException {
        Image image = Toolkit.getDefaultToolkit().getImage(filename);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForID(0);
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        ImageOpt.saveBufferedImage(outFilename, thumbImage, quality);
    }

    public static void saveBufferedImage(String filename, BufferedImage image, int quality) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));){
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            quality = Math.max(0, Math.min(quality, 100));
            param.setQuality((float)quality / 100.0f, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
        }
    }

    public static void captureScreen(String fileName) throws AWTException, IOException {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenRectangle = new Rectangle(screenSize);
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(screenRectangle);
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }

    public static BufferedImage saveSubImage(BufferedImage image, Rectangle subImageBounds) {
        BufferedImage subImage = new BufferedImage(subImageBounds.width, subImageBounds.height, 1);
        Graphics g = subImage.getGraphics();
        if (subImageBounds.width > image.getWidth() || subImageBounds.height > image.getHeight()) {
            int left = subImageBounds.x;
            int top = subImageBounds.y;
            if (image.getWidth() < subImageBounds.width) {
                left = (subImageBounds.width - image.getWidth()) / 2;
            }
            if (image.getHeight() < subImageBounds.height) {
                top = (subImageBounds.height - image.getHeight()) / 2;
            }
            g.setColor(Color.white);
            g.fillRect(0, 0, subImageBounds.width, subImageBounds.height);
            g.drawImage(image, left, top, null);
            return image;
        }
        g.drawImage(image.getSubimage(subImageBounds.x, subImageBounds.y, subImageBounds.width, subImageBounds.height), 0, 0, null);
        g.dispose();
        return subImage;
    }

    public static List<BufferedImage> splitImage(BufferedImage image, int divisions) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (divisions < 2) {
            images.add(image);
            return images;
        }
        int imgWidth = image.getWidth();
        int subImgWidth = imgWidth / divisions;
        int imgHeight = image.getHeight();
        for (int i = 0; i < divisions; ++i) {
            BufferedImage subImage = new BufferedImage(subImgWidth, imgHeight, 1);
            Graphics g = subImage.getGraphics();
            g.drawImage(image.getSubimage(imgWidth * i / divisions, 0, subImgWidth, imgHeight), 0, 0, null);
            g.dispose();
            images.add(subImage);
        }
        return images;
    }

    public static int[] getRGB(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] inPixels = new int[width * height];
        return ImageOpt.getRGB(image, 0, 0, width, height, inPixels);
    }

    public static int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
        }
        return image.getRGB(x, y, width, height, pixels, 0, width);
    }

    public static BufferedImage createIdIcon(String id, int imageSize, int pointWidth, boolean singleColor, boolean symmetric) {
        byte[] idMd5;
        int step = imageSize / pointWidth;
        if (step > 11) {
            step = 10;
            pointWidth = imageSize / 10;
        }
        if (imageSize % pointWidth != 0) {
            imageSize = step * pointWidth;
        }
        if ((idMd5 = Md5Encoder.rawEncode(id.getBytes())) == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(imageSize, imageSize, 1);
        Color showColor = new Color(idMd5[0] & 0xFF, idMd5[1] & 0xFF, idMd5[2] & 0xFF);
        Graphics2D g = image.createGraphics();
        int mid = (step - 1) / 2;
        for (int i = 0; i < step; ++i) {
            for (int j = 0; j < step; ++j) {
                boolean isColor;
                int row = symmetric && i > mid ? step - i - 1 : i;
                int n = (row * step + j) / 8;
                int b = (row * step + j) % 8;
                boolean bl = isColor = (idMd5[n] & 1 << b) != 0;
                if (j == 0 || row == 0 || j == step - 1 || row == step - 1) {
                    if (isColor) {
                        g.setColor(new Color(214, 214, 214));
                    } else {
                        g.setColor(new Color(235, 235, 235));
                    }
                } else if (isColor) {
                    if (singleColor) {
                        g.setColor(showColor);
                    } else {
                        g.setColor(new Color(idMd5[n] & 0xFF, idMd5[(n * b + b) % 16] % 256 & 0xFF, idMd5[(n + b) % 16] % 256 & 0xFF));
                    }
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.fillRect(i * pointWidth, j * pointWidth, pointWidth, pointWidth);
            }
        }
        g.dispose();
        return image;
    }

    public static BufferedImage createIdIcon(String id, int imageSize, int pointWidth) {
        return ImageOpt.createIdIcon(id, imageSize, pointWidth, true, true);
    }
}

