package com.centit.framework.cas.handler;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.cas.config.QueryUserProperties;
import com.centit.framework.cas.model.Md5PasswordCredential;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import com.centit.support.database.utils.TransactionHandler;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;

import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 南大先腾 技术管理中心
 *
 * @author codefan@sina.comc
 * @since 1.0.2
 */
public class Md5PasswordAuthenticationHandler extends AbstractPreAndPostProcessingAuthenticationHandler {

    public QueryUserProperties queryUserProperties;

    private PasswordEncoder passwordEncoder;

    public Md5PasswordAuthenticationHandler(String name, ServicesManager servicesManager,
                                            PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    @Override
    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        //当用户名为admin,并且system为sso即允许通过
        String userName = null;
        String userPwd = null;
        String topUnit = null;
        boolean isRest = false;
        if (credential instanceof Md5PasswordCredential) {
            Md5PasswordCredential pc = (Md5PasswordCredential) credential;
            userName = pc.getUsername();
            userPwd = pc.getPassword();
            topUnit = pc.getTopUnit();
        }
        if (credential instanceof UsernamePasswordCredential) {
            isRest = true;
            UsernamePasswordCredential nc = (UsernamePasswordCredential) credential;
            userName = nc.getUsername();
            userPwd = nc.getPassword();
        }
        if (StringUtils.isBlank(userName)) {
            throw new AccountNotFoundException("输入的用户名为空！");
        }
        //这里可以自定义属性数据
        try (Connection conn
                     = DbcpConnectPools.getDbcpConnect(queryUserProperties.getDatasource())) {
            Integer intParamsTimes = queryUserProperties.getParamRepeatTimes();
            if (intParamsTimes == null || intParamsTimes < 1)
                intParamsTimes = 1;
            Object[] param = new Object[intParamsTimes];
            for (int i = 0; i < intParamsTimes; i++) {
                param[i] = userName;
            }
            JSONObject user = DatabaseAccess.getObjectAsJSON(conn, queryUserProperties.getSql(), param);
            if (user == null) {
                throw new AccountNotFoundException("用户找不到！");
            }
            String password = user.getString(DatabaseAccess.mapColumnNameToField(queryUserProperties.getPinField()));
            if (!passwordEncoder.matches(userPwd, password)) {
                throw new FailedLoginException("用户名密码不匹配。");
            }

            if (StringUtils.isNotBlank(queryUserProperties.getDisabledField())) {
                final Object dbDisabled = user.get(DatabaseAccess.mapColumnNameToField(queryUserProperties.getDisabledField()));
                if (BooleanBaseOpt.castObjectToBoolean(dbDisabled, false)) {
                    throw new AccountDisabledException("用户已经失效");
                }
            }

            if (StringUtils.isNotBlank(queryUserProperties.getExpiredField())) {
                final Object dbDisabled = user.get(DatabaseAccess.mapColumnNameToField(queryUserProperties.getExpiredField()));
                if (BooleanBaseOpt.castObjectToBoolean(dbDisabled, false)) {
                    throw new AccountPasswordMustChangeException("密码已过期");
                }
            }

            if (!isRest) {
                Object[] unitParam = new Object[1];
                String userCode = user.getString("userCode");
                String topUnitCode = user.getString("topUnit");
                unitParam[0] = userCode;
                //查询用户所属机构租户
                String sql = "SELECT UNIT_WORD,TOP_UNIT FROM F_UNITINFO WHERE UNIT_CODE IN ( " +
                        "SELECT DISTINCT TOP_UNIT FROM F_USERUNIT WHERE USER_CODE = ? )";
                List<Object[]> units = DatabaseAccess.findObjectsBySql(conn, sql, unitParam);
                List<String> unitList = new ArrayList<>();
                Map<String, String> topUnitMap = new HashMap<>();
                if (!CollectionUtils.isEmpty(units)) {
                    units.forEach(unit -> {
                                if (null != unit && unit.length > 0 && null != unit[0]) {
                                    unitList.add(unit[0].toString());
                                }
                                if (unit.length > 1 && null != unit[1]) {
                                    topUnitMap.put(unit[0].toString(), unit[1].toString());
                                }
                            }
                    );
                    if (CollectionUtils.isEmpty(unitList)) {
                        throw new FailedLoginException(userName + "该用户未分配公司代码");
                    }
                    if (!unitList.contains(topUnit)) {
                        throw new FailedLoginException(userName + "用户公司代码不匹配！");
                    }
                } else {
                    //区分自定义的租户代码
                    sql = "SELECT DISTINCT TOP_UNIT FROM F_USERUNIT WHERE USER_CODE = ? ";
                    List<Object[]> topUnits = DatabaseAccess.findObjectsBySql(conn, sql, unitParam);
                    if (!CollectionUtils.isEmpty(topUnits)) {
                        topUnits.forEach(unit -> {
                            if (null != unit && unit.length > 0 && null != unit[0]) {
                                unitList.add(unit[0].toString());
                            }
                        });
                        if (CollectionUtils.isEmpty(unitList)) {
                            throw new FailedLoginException(userName + "该用户未分配公司代码");
                        }
                        if (!unitList.contains(topUnit)) {
                            throw new FailedLoginException(userName + "用户公司代码不匹配！");
                        }
                    } else {
                        throw new FailedLoginException(userName + "该用户未分配公司代码");
                    }
                }
                if (null != topUnitMap.get(topUnit) && !topUnitMap.get(topUnit).equals(topUnitCode)) {
                    Object[] updateParam = new Object[2];
                    updateParam[0] = topUnitMap.get(topUnit);
                    updateParam[1] = userCode;
                    String updateSql = "UPDATE F_USERINFO SET TOP_UNIT = ? WHERE USER_CODE = ? ";
                    try {
                        TransactionHandler.executeInTransaction(
                                queryUserProperties.getDatasource(),
                                (connection) -> DatabaseAccess.doExecuteSql(connection, updateSql, updateParam)
                        );
                    } catch (SQLException e) {
                        throw new FailedLoginException("更改用户默认公司代码异常！");
                    }
                    user.put("topUnit", topUnitMap.get(topUnit));
                }
            }

            String principal = userName;
            String principalKey = queryUserProperties.getPrincipalField();
            if (StringUtils.isNotBlank(principalKey) && !"none".equalsIgnoreCase(principalKey)) {
                String tempPrincipal = user.getString(DatabaseAccess.mapColumnNameToField(principalKey));
                if (StringUtils.isNotBlank(tempPrincipal)) {
                    principal = tempPrincipal;
                }
            }
            user.remove(DatabaseAccess.mapColumnNameToField(queryUserProperties.getPinField()));
            return createHandlerResult(credential, this.principalFactory.createPrincipal(principal, user));

        } catch (SQLException | IOException e) {
            throw new AccountNotFoundException("查找用户 " + userName + " 报错 " + e.getLocalizedMessage());
        }
    }


    @Override
    public boolean supports(Credential credential) {
        return (credential instanceof Md5PasswordCredential)
                || (credential instanceof UsernamePasswordCredential);
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setQueryUserProperties(QueryUserProperties queryUserProperties) {
        this.queryUserProperties = queryUserProperties;
    }
}
