/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.actions;

import com.centit.framework.cas.config.StrategyProperties;
import com.centit.framework.cas.model.ComplexAuthCredential;
import com.centit.support.algorithm.StringBaseOpt;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ChangeAuthenticationAction
extends AbstractAction {
    private StrategyProperties strategyConfig;

    protected Event doExecute(RequestContext context) throws Exception {
        ComplexAuthCredential credential = (ComplexAuthCredential)WebUtils.getCredential((RequestContext)context);
        if (credential != null) {
            return new Event((Object)this, credential.getAuthType());
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpSession httpSession = request.getSession();
        String currentAuthType = StringBaseOpt.castObjectToString((Object)httpSession.getAttribute("_currentAuthType"));
        if (StringUtils.isNotBlank((CharSequence)currentAuthType)) {
            return new Event((Object)this, currentAuthType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.strategyConfig.getDefaultAuthType())) {
            return new Event((Object)this, this.strategyConfig.getDefaultAuthType());
        }
        return new Event((Object)this, "password");
    }

    public void setStrategyConfig(StrategyProperties strategyConfig) {
        this.strategyConfig = strategyConfig;
    }
}

