/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.config;

import com.centit.framework.cas.config.ComplexConfigurationProperties;
import com.centit.framework.cas.handler.LdapAuthenticationHandler;
import com.centit.framework.cas.handler.Md5PasswordAuthenticationHandler;
import com.centit.framework.cas.utils.CentitPasswordEncoder;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="complexAuthEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={ComplexConfigurationProperties.class})
public class ComplexAuthEventExecutionPlanConfiguration
implements AuthenticationEventExecutionPlanConfigurer {
    @Autowired
    private ComplexConfigurationProperties complexProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Bean
    public AuthenticationHandler md5PasswordAuthenticationHandler() {
        Md5PasswordAuthenticationHandler authenticationHandler = new Md5PasswordAuthenticationHandler("md5PasswordAuthenticationHandler", this.servicesManager, (PrincipalFactory)new DefaultPrincipalFactory(), 1);
        authenticationHandler.setPasswordEncoder(new CentitPasswordEncoder());
        authenticationHandler.setQueryUserProperties(this.complexProperties.getQueryUser());
        return authenticationHandler;
    }

    @Bean
    public AuthenticationHandler ldapAuthenticationHandler() {
        LdapAuthenticationHandler authenticationHandler = new LdapAuthenticationHandler("ldapAuthenticationHandler", this.servicesManager, (PrincipalFactory)new DefaultPrincipalFactory(), 1);
        authenticationHandler.setLdapProperties(this.complexProperties.getLdap());
        return authenticationHandler;
    }

    public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
        plan.registerAuthenticationHandler(this.md5PasswordAuthenticationHandler());
        plan.registerAuthenticationHandler(this.ldapAuthenticationHandler());
    }
}

