/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.controller;

import com.centit.support.image.CaptchaImageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.web.AbstractDelegateController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class CaptchaController
extends AbstractDelegateController {
    private static Logger logger = LoggerFactory.getLogger(CaptchaController.class);

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @GetMapping(value={"/captcha"}, produces={"image/gif"})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String checkcode = CaptchaImageUtil.getRandomString();
        request.getSession().setAttribute("session_checkcode", (Object)checkcode);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("image/gif");
        BufferedImage image = CaptchaImageUtil.generateCaptchaImage((String)checkcode);
        try (ServletOutputStream os = response.getOutputStream();){
            ImageIO.write((RenderedImage)image, "gif", (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }
}

