/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.utils;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.security.Md5Encoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCrypt;

public class CentitPasswordEncoder
implements PasswordEncoder {
    private int strength;

    public CentitPasswordEncoder() {
        this.strength = 11;
    }

    public CentitPasswordEncoder(int strength) {
        this.strength = strength < 5 || strength > 31 ? strength : 11;
    }

    public String encodePassword(String rawPass, Object salt) {
        return CentitPasswordEncoder.createPassword(rawPass, StringBaseOpt.castObjectToString((Object)salt), this.strength);
    }

    public boolean isPasswordValid(String encodedPassword, String rawPass, Object salt) {
        return StringUtils.equals((CharSequence)encodedPassword, (CharSequence)CentitPasswordEncoder.createPassword(rawPass, StringBaseOpt.castObjectToString((Object)salt), this.strength));
    }

    public static String createPassword(String password, String rawSalt, int logRounds) {
        String salt = StringUtils.isBlank((CharSequence)rawSalt) ? "salt" : rawSalt;
        try {
            BCrypt b = new BCrypt();
            Method method = BCrypt.class.getDeclaredMethod("crypt_raw", byte[].class, byte[].class, Integer.TYPE);
            method.setAccessible(true);
            byte[] pb = (byte[])method.invoke((Object)b, password.getBytes(), salt.getBytes(), logRounds);
            return new String(Hex.encodeHex((byte[])pb));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return Md5Encoder.encodePasswordAsJasigCas((String)password, (String)salt, (int)logRounds);
        }
    }
}

