/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.audit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.cas.audit.LoginLogger;
import com.centit.framework.cas.config.JdbcLoggerProperties;
import com.centit.framework.cas.model.ComplexAuthCredential;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.TransactionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.inspektr.common.web.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLoginLogger
implements LoginLogger {
    private static Logger logger = LoggerFactory.getLogger(JdbcLoginLogger.class);
    private JdbcLoggerProperties jdbcLoggerConfig;

    private Map<String, Object> makeParams(ComplexAuthCredential credential, ClientInfo clientInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>(20);
        params.put("username", credential.getId());
        params.put("loginTime", DatetimeOpt.currentUtilDate());
        params.put("loginIp", clientInfo == null ? "" : clientInfo.getClientIpAddress());
        params.put("macAddr", credential.getMacAddr());
        params.put("authType", credential.getAuthType());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)credential);
        jsonObject.remove((Object)"password");
        params.put("credential", jsonObject.toJSONString());
        return params;
    }

    private void writeLogBySql(String sql, Map<String, Object> params) {
        try {
            TransactionHandler.executeInTransaction((DataSourceDescription)this.jdbcLoggerConfig.getDatasource(), conn -> DatabaseAccess.doExecuteNamedSql((Connection)conn, (String)sql, (Map)params));
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage());
        }
    }

    @Override
    public void logSuccess(ComplexAuthCredential credential, ClientInfo clientInfo, Authentication auth) {
        if (credential == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.jdbcLoggerConfig.getSuccessSql())) {
            Map<String, Object> params = this.makeParams(credential, clientInfo);
            if (auth != null) {
                params.put("principle", auth.getPrincipal());
                params.put("auth", JSON.toJSONString((Object)auth.getAttributes()));
            }
            this.writeLogBySql(this.jdbcLoggerConfig.getSuccessSql(), params);
        }
    }

    @Override
    public void logError(ComplexAuthCredential credential, ClientInfo clientInfo) {
        if (credential == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.jdbcLoggerConfig.getErrorSql())) {
            this.writeLogBySql(this.jdbcLoggerConfig.getErrorSql(), this.makeParams(credential, clientInfo));
        }
    }

    @Override
    public void logWarn(ComplexAuthCredential credential, ClientInfo clientInfo) {
        if (credential == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.jdbcLoggerConfig.getWarnSql())) {
            this.writeLogBySql(this.jdbcLoggerConfig.getWarnSql(), this.makeParams(credential, clientInfo));
        }
    }

    @Override
    public void logFailedLogin(ComplexAuthCredential credential, ClientInfo clientInfo) {
        if (credential == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.jdbcLoggerConfig.getFailedLoginSql())) {
            this.writeLogBySql(this.jdbcLoggerConfig.getFailedLoginSql(), this.makeParams(credential, clientInfo));
        }
    }

    public void setJdbcLoggerConfig(JdbcLoggerProperties jdbcLoggerConfig) {
        this.jdbcLoggerConfig = jdbcLoggerConfig;
    }
}

