/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.handler;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.cas.config.SyncUserProperties;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import com.centit.support.database.utils.TransactionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUserInfo {
    private static Logger logger = LoggerFactory.getLogger(SyncUserInfo.class);
    private SyncUserProperties syncUserProperties;

    public void setSyncUserProperties(SyncUserProperties syncUserProperties) {
        this.syncUserProperties = syncUserProperties;
    }

    public void syncUser(Principal principal) {
        try (Connection conn = DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.syncUserProperties.getDatasource());){
            Object[] unitParam = new Object[]{principal.getAttributes().get("memberOf")};
            JSONObject unit = DatabaseAccess.getObjectAsJSON((Connection)conn, (String)this.syncUserProperties.getQueryUnitSql(), (Object[])unitParam);
            String unitcode = UuidOpt.getUuidAsString22();
            if (null == unit) {
                Map<String, Object> params = SyncUserInfo.makeUnitParams(principal.getAttributes());
                params.put("unitcode", unitcode);
                params.put("unitpath", "/" + unitcode);
                this.saveUserInfo(this.syncUserProperties.getInsertUnitSql(), params);
            } else {
                unitcode = unit.getString("unitCode");
            }
            Object[] userParam = new Object[]{principal.getAttributes().get("sAMAccountName")};
            JSONObject user = DatabaseAccess.getObjectAsJSON((Connection)conn, (String)this.syncUserProperties.getQueryUserSql(), (Object[])userParam);
            String usercode = UuidOpt.getUuidAsString22();
            if (null == user) {
                Map<String, Object> params = SyncUserInfo.makeUserParams(principal.getAttributes());
                params.put("usercode", usercode);
                params.put("primaryunit", unitcode);
                this.saveUserInfo(this.syncUserProperties.getInsertUserSql(), params);
            } else {
                usercode = user.getString("userCode");
            }
            Object[] param = new Object[]{usercode, unitcode};
            Long userUnit = DatabaseAccess.queryTotalRows((Connection)conn, (String)this.syncUserProperties.getQueryUserUnitSql(), (Object[])param);
            if (userUnit == 0L) {
                Map<String, Object> params = SyncUserInfo.makeUserUnitParams(principal.getAttributes());
                params.put("unitcode", unitcode);
                params.put("usercode", usercode);
                this.saveUserInfo(this.syncUserProperties.getInsertUserUnitSql(), params);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u7528\u6237 " + principal.getAttributes().get("sAMAccountName") + " \u62a5\u9519 " + e.getLocalizedMessage());
        }
    }

    private static Map<String, Object> makeUnitParams(Map<String, Object> principal) {
        HashMap<String, Object> params = new HashMap<String, Object>(20);
        params.put("unittag", principal.get("memberOf"));
        params.put("isvalid", "T");
        params.put("unittype", "A");
        params.put("createdate", DatetimeOpt.currentUtilDate());
        params.put("unitname", principal.get("description"));
        params.put("unitdesc", "");
        params.put("updatedate", DatetimeOpt.currentUtilDate());
        return params;
    }

    private static Map<String, Object> makeUserParams(Map<String, Object> principal) {
        HashMap<String, Object> params = new HashMap<String, Object>(20);
        params.put("userpin", "");
        params.put("usertype", "U");
        params.put("isvalid", "T");
        params.put("loginname", principal.get("sAMAccountName"));
        params.put("username", principal.get("displayName"));
        params.put("usertag", principal.get("distinguishedName"));
        params.put("regemail", principal.get("mail"));
        params.put("userword", principal.get("jobNo"));
        params.put("userorder", "");
        params.put("updatedate", DatetimeOpt.currentUtilDate());
        params.put("createdate", DatetimeOpt.currentUtilDate());
        return params;
    }

    private static Map<String, Object> makeUserUnitParams(Map<String, Object> principal) {
        HashMap<String, Object> params = new HashMap<String, Object>(20);
        params.put("userunitid", UuidOpt.getUuidAsString22());
        params.put("isprimary", "F");
        params.put("userstation", "ZY");
        params.put("userrank", "YG");
        params.put("userorder", 0);
        params.put("updatedate", DatetimeOpt.currentUtilDate());
        params.put("createdate", DatetimeOpt.currentUtilDate());
        return params;
    }

    private void saveUserInfo(String sql, Map<String, Object> params) {
        try {
            TransactionHandler.executeInTransaction((DataSourceDescription)this.syncUserProperties.getDatasource(), conn -> DatabaseAccess.doExecuteNamedSql((Connection)conn, (String)sql, (Map)params));
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage());
        }
    }
}

