/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.handler;

import com.centit.framework.cas.audit.JdbcLoginLogger;
import com.centit.framework.cas.config.LdapProperties;
import com.centit.framework.cas.model.LdapCredential;
import com.centit.framework.cas.utils.PrincipalUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.Pretreatment;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static Logger logger = LoggerFactory.getLogger(JdbcLoginLogger.class);
    private LdapProperties ldapProperties;

    public LdapAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPasswordByDn(String username, String password) throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", this.ldapProperties.getUrl());
        try (InitialLdapContext ctx = null;){
            ctx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
    }

    public static String getAttributeString(Attributes attrs, String attrName) {
        Attribute attr = attrs.get(attrName);
        if (attr == null) {
            return null;
        }
        try {
            return StringBaseOpt.objectToString((Object)attr.get());
        }
        catch (NamingException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public Principal searchPrincipalByCredential(Credential credential) {
        block6: {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.ldapProperties.getUsername());
            env.put("java.naming.security.credentials", this.ldapProperties.getPassword());
            env.put("java.naming.provider.url", this.ldapProperties.getUrl());
            InitialLdapContext ctx = null;
            try {
                ctx = new InitialLdapContext(env, null);
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                for (String filterStr : this.ldapProperties.getSearchFilter()) {
                    SearchResult sr;
                    Attributes attrs;
                    String principalId;
                    String searchFilter = MessageFormat.format(filterStr, credential.getId());
                    searchCtls.setReturningAttributes(this.ldapProperties.getPrincipalAttributesAsArray());
                    NamingEnumeration<SearchResult> answer = ctx.search(this.ldapProperties.getSearchBase(), searchFilter, searchCtls);
                    if (!answer.hasMoreElements() || !StringUtils.isNotBlank((CharSequence)(principalId = LdapAuthenticationHandler.getAttributeString(attrs = (sr = answer.next()).getAttributes(), this.ldapProperties.getPrincipalIdField())))) continue;
                    HashMap<String, Object> attributes = new HashMap<String, Object>(20);
                    NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
                    while (enumeration.hasMore()) {
                        Attribute attr = enumeration.next();
                        attributes.put(attr.getID(), attr.get());
                    }
                    ctx.close();
                    return this.principalFactory.createPrincipal(principalId, PrincipalUtils.makePrinciupalAttributes(attributes));
                }
                ctx.close();
            }
            catch (NamingException e) {
                if (ctx == null) break block6;
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        LdapCredential adCredential = (LdapCredential)credential;
        Principal principal = this.searchPrincipalByCredential(credential);
        if (principal == null) {
            throw new AccountNotFoundException("\u7528\u6237\u627e\u4e0d\u5230\uff01");
        }
        try {
            boolean passed = this.checkUserPasswordByDn(Pretreatment.mapTemplateString((String)this.ldapProperties.getDnFormat(), (Object)principal.getAttributes()), adCredential.getPassword());
            if (!passed) {
                throw new FailedLoginException("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\u3002");
            }
        }
        catch (NamingException e) {
            throw new FailedLoginException(e.getLocalizedMessage());
        }
        return this.createHandlerResult(credential, principal);
    }

    public boolean supports(Credential credential) {
        return credential instanceof LdapCredential;
    }

    public void setLdapProperties(LdapProperties ldapProperties) {
        this.ldapProperties = ldapProperties;
    }
}

