/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.cas.handler;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.cas.config.QueryUserProperties;
import com.centit.framework.cas.model.Md5PasswordCredential;
import com.centit.framework.cas.utils.PrincipalUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.security.crypto.password.PasswordEncoder;

public class Md5PasswordAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    public QueryUserProperties queryUserProperties;
    private PasswordEncoder passwordEncoder;

    public Md5PasswordAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult;
        block16: {
            Md5PasswordCredential passwordCredential = (Md5PasswordCredential)credential;
            if (StringUtils.isBlank((CharSequence)passwordCredential.getUsername())) {
                throw new AccountNotFoundException("\u8f93\u5165\u7684\u7528\u6237\u540d\u4e3a\u7a7a\uff01");
            }
            Connection conn = DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.queryUserProperties.getDatasource());
            try {
                String tempPrincipal;
                Object dbDisabled;
                Integer intParamsTimes = this.queryUserProperties.getParamRepeatTimes();
                if (intParamsTimes == null || intParamsTimes < 1) {
                    intParamsTimes = 1;
                }
                Object[] param = new Object[intParamsTimes.intValue()];
                for (int i = 0; i < intParamsTimes; ++i) {
                    param[i] = passwordCredential.getUsername();
                }
                JSONObject user = DatabaseAccess.getObjectAsJSON((Connection)conn, (String)this.queryUserProperties.getSql(), (Object[])param);
                if (user == null) {
                    throw new AccountNotFoundException("\u7528\u6237\u627e\u4e0d\u5230\uff01");
                }
                String password = user.getString(DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getPinField()));
                if (!this.passwordEncoder.matches((CharSequence)passwordCredential.getPassword(), password)) {
                    throw new FailedLoginException("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\u3002");
                }
                if (StringUtils.isNotBlank((CharSequence)this.queryUserProperties.getDisabledField()) && BooleanBaseOpt.castObjectToBoolean((Object)(dbDisabled = user.get((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getDisabledField()))), (Boolean)false).booleanValue()) {
                    throw new AccountDisabledException("\u7528\u6237\u5df2\u7ecf\u5931\u6548");
                }
                if (StringUtils.isNotBlank((CharSequence)this.queryUserProperties.getExpiredField()) && BooleanBaseOpt.castObjectToBoolean((Object)(dbDisabled = user.get((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getExpiredField()))), (Boolean)false).booleanValue()) {
                    throw new AccountPasswordMustChangeException("\u5bc6\u7801\u5df2\u8fc7\u671f");
                }
                String principal = passwordCredential.getUsername();
                String principalKey = this.queryUserProperties.getPrincipalField();
                if (StringUtils.isNotBlank((CharSequence)principalKey) && !"none".equalsIgnoreCase(principalKey) && StringUtils.isNotBlank((CharSequence)(tempPrincipal = user.getString(DatabaseAccess.mapColumnNameToField((String)principalKey))))) {
                    principal = tempPrincipal;
                }
                user.remove((Object)DatabaseAccess.mapColumnNameToField((String)this.queryUserProperties.getPinField()));
                authenticationHandlerExecutionResult = this.createHandlerResult(credential, this.principalFactory.createPrincipal(principal, PrincipalUtils.makePrinciupalAttributes((Map<String, Object>)user)));
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw new AccountNotFoundException("\u67e5\u627e\u7528\u6237 " + passwordCredential.getUsername() + " \u62a5\u9519 " + e.getLocalizedMessage());
                }
            }
            conn.close();
        }
        return authenticationHandlerExecutionResult;
    }

    public boolean supports(Credential credential) {
        return credential instanceof Md5PasswordCredential;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setQueryUserProperties(QueryUserProperties queryUserProperties) {
        this.queryUserProperties = queryUserProperties;
    }
}

